/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.net.IndexedLambda;
import org.onosproject.net.Lambda;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPDscpCriterion;
import org.onosproject.net.flow.criteria.IPEcnCriterion;
import org.onosproject.net.flow.criteria.IPProtocolCriterion;
import org.onosproject.net.flow.criteria.IPv6ExthdrFlagsCriterion;
import org.onosproject.net.flow.criteria.IPv6FlowLabelCriterion;
import org.onosproject.net.flow.criteria.IPv6NDLinkLayerAddressCriterion;
import org.onosproject.net.flow.criteria.IPv6NDTargetAddressCriterion;
import org.onosproject.net.flow.criteria.IcmpCodeCriterion;
import org.onosproject.net.flow.criteria.IcmpTypeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6CodeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6TypeCriterion;
import org.onosproject.net.flow.criteria.IndexedLambdaCriterion;
import org.onosproject.net.flow.criteria.LambdaCriterion;
import org.onosproject.net.flow.criteria.MetadataCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.OchSignalCriterion;
import org.onosproject.net.flow.criteria.OchSignalTypeCriterion;
import org.onosproject.net.flow.criteria.OpticalSignalTypeCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.SctpPortCriterion;
import org.onosproject.net.flow.criteria.TcpPortCriterion;
import org.onosproject.net.flow.criteria.UdpPortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.criteria.VlanPcpCriterion;

public final class Criteria {
    private Criteria() {
    }

    public static Criterion matchInPort(PortNumber port) {
        return new PortCriterion(port, Criterion.Type.IN_PORT);
    }

    public static Criterion matchInPhyPort(PortNumber port) {
        return new PortCriterion(port, Criterion.Type.IN_PHY_PORT);
    }

    public static Criterion matchMetadata(long metadata) {
        return new MetadataCriterion(metadata);
    }

    public static Criterion matchEthDst(MacAddress mac) {
        return new EthCriterion(mac, Criterion.Type.ETH_DST);
    }

    public static Criterion matchEthSrc(MacAddress mac) {
        return new EthCriterion(mac, Criterion.Type.ETH_SRC);
    }

    public static Criterion matchEthType(int ethType) {
        return new EthTypeCriterion(ethType);
    }

    public static Criterion matchVlanId(VlanId vlanId) {
        return new VlanIdCriterion(vlanId);
    }

    public static Criterion matchVlanPcp(byte vlanPcp) {
        return new VlanPcpCriterion(vlanPcp);
    }

    public static Criterion matchIPDscp(byte ipDscp) {
        return new IPDscpCriterion(ipDscp);
    }

    public static Criterion matchIPEcn(byte ipEcn) {
        return new IPEcnCriterion(ipEcn);
    }

    public static Criterion matchIPProtocol(short proto) {
        return new IPProtocolCriterion(proto);
    }

    public static Criterion matchIPSrc(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV4_SRC);
    }

    public static Criterion matchIPDst(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV4_DST);
    }

    public static Criterion matchTcpSrc(int tcpPort) {
        return new TcpPortCriterion(tcpPort, Criterion.Type.TCP_SRC);
    }

    public static Criterion matchTcpDst(int tcpPort) {
        return new TcpPortCriterion(tcpPort, Criterion.Type.TCP_DST);
    }

    public static Criterion matchUdpSrc(int udpPort) {
        return new UdpPortCriterion(udpPort, Criterion.Type.UDP_SRC);
    }

    public static Criterion matchUdpDst(int udpPort) {
        return new UdpPortCriterion(udpPort, Criterion.Type.UDP_DST);
    }

    public static Criterion matchSctpSrc(int sctpPort) {
        return new SctpPortCriterion(sctpPort, Criterion.Type.SCTP_SRC);
    }

    public static Criterion matchSctpDst(int sctpPort) {
        return new SctpPortCriterion(sctpPort, Criterion.Type.SCTP_DST);
    }

    public static Criterion matchIcmpType(short icmpType) {
        return new IcmpTypeCriterion(icmpType);
    }

    public static Criterion matchIcmpCode(short icmpCode) {
        return new IcmpCodeCriterion(icmpCode);
    }

    public static Criterion matchIPv6Src(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV6_SRC);
    }

    public static Criterion matchIPv6Dst(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV6_DST);
    }

    public static Criterion matchIPv6FlowLabel(int flowLabel) {
        return new IPv6FlowLabelCriterion(flowLabel);
    }

    public static Criterion matchIcmpv6Type(short icmpv6Type) {
        return new Icmpv6TypeCriterion(icmpv6Type);
    }

    public static Criterion matchIcmpv6Code(short icmpv6Code) {
        return new Icmpv6CodeCriterion(icmpv6Code);
    }

    public static Criterion matchIPv6NDTargetAddress(Ip6Address targetAddress) {
        return new IPv6NDTargetAddressCriterion(targetAddress);
    }

    public static Criterion matchIPv6NDSourceLinkLayerAddress(MacAddress mac) {
        return new IPv6NDLinkLayerAddressCriterion(mac, Criterion.Type.IPV6_ND_SLL);
    }

    public static Criterion matchIPv6NDTargetLinkLayerAddress(MacAddress mac) {
        return new IPv6NDLinkLayerAddressCriterion(mac, Criterion.Type.IPV6_ND_TLL);
    }

    public static Criterion matchMplsLabel(MplsLabel mplsLabel) {
        return new MplsCriterion(mplsLabel);
    }

    public static Criterion matchIPv6ExthdrFlags(int exthdrFlags) {
        return new IPv6ExthdrFlagsCriterion(exthdrFlags);
    }

    @Deprecated
    public static Criterion matchLambda(int lambda) {
        return new LambdaCriterion(lambda, Criterion.Type.OCH_SIGID);
    }

    public static Criterion matchLambda(Lambda lambda) {
        if (lambda instanceof IndexedLambda) {
            return new IndexedLambdaCriterion((IndexedLambda)lambda);
        }
        if (lambda instanceof OchSignal) {
            return new OchSignalCriterion((OchSignal)lambda);
        }
        throw new UnsupportedOperationException(String.format("Unsupported type of Lambda: %s", lambda));
    }

    @Deprecated
    public static Criterion matchOpticalSignalType(short sigType) {
        return new OpticalSignalTypeCriterion(sigType, Criterion.Type.OCH_SIGTYPE);
    }

    public static Criterion matchOchSignalType(OchSignalType signalType) {
        return new OchSignalTypeCriterion(signalType);
    }

    public static Criterion dummy() {
        return new DummyCriterion();
    }

    private static class DummyCriterion
    implements Criterion {
        private DummyCriterion() {
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.DUMMY;
        }
    }
}

