/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class IPv6ExthdrFlagsCriterion
implements Criterion {
    private static final int MASK = 65535;
    private final int exthdrFlags;

    IPv6ExthdrFlagsCriterion(int exthdrFlags) {
        this.exthdrFlags = exthdrFlags & 0xFFFF;
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.IPV6_EXTHDR;
    }

    public int exthdrFlags() {
        return this.exthdrFlags;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add("exthdrFlags", (Object)Long.toHexString(this.exthdrFlags)).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.exthdrFlags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IPv6ExthdrFlagsCriterion) {
            IPv6ExthdrFlagsCriterion that = (IPv6ExthdrFlagsCriterion)obj;
            return Objects.equals(this.exthdrFlags, that.exthdrFlags) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

