/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class IcmpTypeCriterion
implements Criterion {
    private static final short MASK = 255;
    private final short icmpType;

    IcmpTypeCriterion(short icmpType) {
        this.icmpType = (short)(icmpType & 0xFF);
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.ICMPV4_TYPE;
    }

    public short icmpType() {
        return this.icmpType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add("icmpType", (int)this.icmpType).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.icmpType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IcmpTypeCriterion) {
            IcmpTypeCriterion that = (IcmpTypeCriterion)obj;
            return Objects.equals(this.icmpType, that.icmpType) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

