/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class SctpPortCriterion
implements Criterion {
    private static final int MASK = 65535;
    private final int sctpPort;
    private final Criterion.Type type;

    SctpPortCriterion(int sctpPort, Criterion.Type type) {
        this.sctpPort = sctpPort & 0xFFFF;
        this.type = type;
    }

    @Override
    public Criterion.Type type() {
        return this.type;
    }

    public int sctpPort() {
        return this.sctpPort;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add("sctpPort", this.sctpPort).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.sctpPort);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SctpPortCriterion) {
            SctpPortCriterion that = (SctpPortCriterion)obj;
            return Objects.equals(this.sctpPort, that.sctpPort) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }
}

