/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class TcpPortCriterion
implements Criterion {
    private static final int MASK = 65535;
    private final int tcpPort;
    private final Criterion.Type type;

    TcpPortCriterion(int tcpPort, Criterion.Type type) {
        this.tcpPort = tcpPort & 0xFFFF;
        this.type = type;
    }

    @Override
    public Criterion.Type type() {
        return this.type;
    }

    public int tcpPort() {
        return this.tcpPort;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add("tcpPort", this.tcpPort).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.tcpPort);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TcpPortCriterion) {
            TcpPortCriterion that = (TcpPortCriterion)obj;
            return Objects.equals(this.tcpPort, that.tcpPort) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }
}

