/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;

@Beta
public final class DefaultFilteringObjective
implements FilteringObjective {
    private final FilteringObjective.Type type;
    private final boolean permanent;
    private final int timeout;
    private final ApplicationId appId;
    private final int priority;
    private final Criterion key;
    private final List<Criterion> conditions;
    private final int id;
    private final Objective.Operation op;
    private final Optional<ObjectiveContext> context;

    private DefaultFilteringObjective(FilteringObjective.Type type, boolean permanent, int timeout, ApplicationId appId, int priority, Criterion key, List<Criterion> conditions, Objective.Operation op) {
        this.key = key;
        this.type = type;
        this.permanent = permanent;
        this.timeout = timeout;
        this.appId = appId;
        this.priority = priority;
        this.conditions = conditions;
        this.op = op;
        this.context = Optional.empty();
        this.id = Objects.hash(new Object[]{type, key, conditions, permanent, timeout, appId, priority});
    }

    public DefaultFilteringObjective(FilteringObjective.Type type, boolean permanent, int timeout, ApplicationId appId, int priority, Criterion key, List<Criterion> conditions, ObjectiveContext context, Objective.Operation op) {
        this.key = key;
        this.type = type;
        this.permanent = permanent;
        this.timeout = timeout;
        this.appId = appId;
        this.priority = priority;
        this.conditions = conditions;
        this.op = op;
        this.context = Optional.ofNullable(context);
        this.id = Objects.hash(new Object[]{type, key, conditions, permanent, timeout, appId, priority});
    }

    @Override
    public Criterion key() {
        return this.key;
    }

    @Override
    public FilteringObjective.Type type() {
        return this.type;
    }

    @Override
    public Collection<Criterion> conditions() {
        return this.conditions;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public ApplicationId appId() {
        return this.appId;
    }

    @Override
    public int timeout() {
        return this.timeout;
    }

    @Override
    public boolean permanent() {
        return this.permanent;
    }

    @Override
    public Objective.Operation op() {
        return this.op;
    }

    @Override
    public Optional<ObjectiveContext> context() {
        return this.context;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements FilteringObjective.Builder {
        private final ImmutableList.Builder<Criterion> listBuilder = ImmutableList.builder();
        private FilteringObjective.Type type;
        private boolean permanent = true;
        private int timeout = 0;
        private ApplicationId appId;
        private int priority = 32768;
        private Criterion key = Criteria.dummy();

        @Override
        public Builder withKey(Criterion key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder addCondition(Criterion criterion) {
            this.listBuilder.add((Object)criterion);
            return this;
        }

        @Override
        public Builder permit() {
            this.type = FilteringObjective.Type.PERMIT;
            return this;
        }

        @Override
        public Builder deny() {
            this.type = FilteringObjective.Type.DENY;
            return this;
        }

        @Override
        public Builder makeTemporary(int timeout) {
            this.timeout = timeout;
            this.permanent = false;
            return this;
        }

        @Override
        public Builder makePermanent() {
            this.permanent = true;
            return this;
        }

        @Override
        public Builder fromApp(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public FilteringObjective add() {
            ImmutableList conditions = this.listBuilder.build();
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Must have a type.");
            Preconditions.checkArgument((!conditions.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one condition.");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            return new DefaultFilteringObjective(this.type, this.permanent, this.timeout, this.appId, this.priority, this.key, (List)conditions, Objective.Operation.ADD);
        }

        @Override
        public FilteringObjective remove() {
            ImmutableList conditions = this.listBuilder.build();
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Must have a type.");
            Preconditions.checkArgument((!conditions.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one condition.");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            return new DefaultFilteringObjective(this.type, this.permanent, this.timeout, this.appId, this.priority, this.key, (List)conditions, Objective.Operation.REMOVE);
        }

        @Override
        public FilteringObjective add(ObjectiveContext context) {
            ImmutableList conditions = this.listBuilder.build();
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Must have a type.");
            Preconditions.checkArgument((!conditions.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one condition.");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            return new DefaultFilteringObjective(this.type, this.permanent, this.timeout, this.appId, this.priority, this.key, (List<Criterion>)conditions, context, Objective.Operation.ADD);
        }

        @Override
        public FilteringObjective remove(ObjectiveContext context) {
            ImmutableList conditions = this.listBuilder.build();
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Must have a type.");
            Preconditions.checkArgument((!conditions.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one condition.");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            return new DefaultFilteringObjective(this.type, this.permanent, this.timeout, this.appId, this.priority, this.key, (List<Criterion>)conditions, context, Objective.Operation.REMOVE);
        }
    }
}

