/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.onlab.packet.MplsLabel;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.Path;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PathIntent;

public final class MplsPathIntent
extends PathIntent {
    private final Optional<MplsLabel> ingressLabel;
    private final Optional<MplsLabel> egressLabel;

    private MplsPathIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, Path path, Optional<MplsLabel> ingressLabel, Optional<MplsLabel> egressLabel, List<Constraint> constraints, int priority) {
        super(appId, selector, treatment, path, constraints, priority);
        this.ingressLabel = (Optional)Preconditions.checkNotNull(ingressLabel);
        this.egressLabel = (Optional)Preconditions.checkNotNull(egressLabel);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<MplsLabel> ingressLabel() {
        return this.ingressLabel;
    }

    public Optional<MplsLabel> egressLabel() {
        return this.egressLabel;
    }

    public static final class Builder
    extends PathIntent.Builder {
        private Optional<MplsLabel> ingressLabel = Optional.empty();
        private Optional<MplsLabel> egressLabel = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints((List)constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        @Override
        public Builder path(Path path) {
            return (Builder)super.path(path);
        }

        public Builder ingressLabel(Optional<MplsLabel> ingressLabel) {
            this.ingressLabel = ingressLabel;
            return this;
        }

        public Builder egressLabel(Optional<MplsLabel> egressLabel) {
            this.egressLabel = egressLabel;
            return this;
        }

        @Override
        public MplsPathIntent build() {
            return new MplsPathIntent(this.appId, this.selector, this.treatment, this.path, this.ingressLabel, this.egressLabel, this.constraints, this.priority);
        }
    }
}

