/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

public final class TwoWayP2PIntent
extends ConnectivityIntent {
    private final ConnectPoint one;
    private final ConnectPoint two;

    private TwoWayP2PIntent(ApplicationId appId, Key key, ConnectPoint one, ConnectPoint two, TrafficSelector selector, TrafficTreatment treatment, List<Constraint> constraints, int priority) {
        super(appId, key, Collections.emptyList(), selector, treatment, constraints, priority);
        this.one = (ConnectPoint)Preconditions.checkNotNull((Object)one);
        this.two = (ConnectPoint)Preconditions.checkNotNull((Object)two);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ConnectPoint one() {
        return this.one;
    }

    public ConnectPoint two() {
        return this.two;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("constraints", this.constraints()).add("one", (Object)this.one).add("two", (Object)this.two).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        ConnectPoint one;
        ConnectPoint two;

        private Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder one(ConnectPoint one) {
            this.one = one;
            return this;
        }

        public Builder two(ConnectPoint two) {
            this.two = two;
            return this;
        }

        public TwoWayP2PIntent build() {
            return new TwoWayP2PIntent(this.appId, this.key, this.one, this.two, this.selector, this.treatment, this.constraints, this.priority);
        }
    }
}

