/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.Link;
import org.onosproject.net.intent.constraint.BooleanConstraint;
import org.onosproject.net.resource.ResourceRequest;
import org.onosproject.net.resource.ResourceType;
import org.onosproject.net.resource.link.BandwidthResource;
import org.onosproject.net.resource.link.BandwidthResourceRequest;
import org.onosproject.net.resource.link.LinkResourceService;

public class BandwidthConstraint
extends BooleanConstraint {
    private final BandwidthResource bandwidth;

    public BandwidthConstraint(BandwidthResource bandwidth) {
        this.bandwidth = (BandwidthResource)Preconditions.checkNotNull((Object)bandwidth, (Object)"Bandwidth cannot be null");
    }

    private BandwidthConstraint() {
        this.bandwidth = null;
    }

    @Override
    public boolean isValid(Link link, LinkResourceService resourceService) {
        for (ResourceRequest request : resourceService.getAvailableResources(link)) {
            BandwidthResourceRequest brr;
            if (request.type() != ResourceType.BANDWIDTH || !((brr = (BandwidthResourceRequest)request).bandwidth().toDouble() >= this.bandwidth.toDouble())) continue;
            return true;
        }
        return false;
    }

    public BandwidthResource bandwidth() {
        return this.bandwidth;
    }

    public int hashCode() {
        return Objects.hash(this.bandwidth);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BandwidthConstraint other = (BandwidthConstraint)obj;
        return Objects.equals(this.bandwidth, other.bandwidth);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bandwidth", (Object)this.bandwidth).toString();
    }
}

