/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.intent.constraint.BooleanConstraint;
import org.onosproject.net.resource.link.LinkResourceService;

public class ObstacleConstraint
extends BooleanConstraint {
    private final Set<DeviceId> obstacles;

    public ObstacleConstraint(DeviceId ... obstacles) {
        this.obstacles = ImmutableSet.copyOf((Object[])obstacles);
    }

    private ObstacleConstraint() {
        this.obstacles = Collections.emptySet();
    }

    public Set<DeviceId> obstacles() {
        return this.obstacles;
    }

    @Override
    public boolean isValid(Link link, LinkResourceService resourceService) {
        DeviceId src = link.src().deviceId();
        DeviceId dst = link.dst().deviceId();
        return !this.obstacles.contains(src) && !this.obstacles.contains(dst);
    }

    public int hashCode() {
        return Objects.hash(this.obstacles);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObstacleConstraint)) {
            return false;
        }
        ObstacleConstraint that = (ObstacleConstraint)obj;
        return Objects.equals(this.obstacles, that.obstacles);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("obstacles", this.obstacles).toString();
    }
}

