/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource.link;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.onlab.util.Bandwidth;
import org.onosproject.net.Link;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.intent.constraint.LambdaConstraint;
import org.onosproject.net.resource.ResourceRequest;
import org.onosproject.net.resource.ResourceType;
import org.onosproject.net.resource.link.BandwidthResource;
import org.onosproject.net.resource.link.BandwidthResourceRequest;
import org.onosproject.net.resource.link.LambdaResourceRequest;
import org.onosproject.net.resource.link.LinkResourceRequest;
import org.onosproject.net.resource.link.MplsLabelResourceRequest;

public final class DefaultLinkResourceRequest
implements LinkResourceRequest {
    private final IntentId intentId;
    private final Collection<Link> links;
    private final Set<ResourceRequest> resources;

    private DefaultLinkResourceRequest(IntentId intentId, Collection<Link> links, Set<ResourceRequest> resources) {
        this.intentId = intentId;
        this.links = ImmutableSet.copyOf(links);
        this.resources = ImmutableSet.copyOf(resources);
    }

    @Override
    public ResourceType type() {
        return null;
    }

    @Override
    public IntentId intentId() {
        return this.intentId;
    }

    @Override
    public Collection<Link> links() {
        return this.links;
    }

    @Override
    public Set<ResourceRequest> resources() {
        return this.resources;
    }

    public static LinkResourceRequest.Builder builder(IntentId intentId, Collection<Link> links) {
        return new Builder(intentId, links);
    }

    public int hashCode() {
        return Objects.hash(this.intentId, this.links);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultLinkResourceRequest other = (DefaultLinkResourceRequest)obj;
        return Objects.equals(this.intentId, other.intentId) && Objects.equals(this.links, other.links);
    }

    public static final class Builder
    implements LinkResourceRequest.Builder {
        private IntentId intentId;
        private Collection<Link> links;
        private Set<ResourceRequest> resources;

        private Builder(IntentId intentId, Collection<Link> links) {
            this.intentId = intentId;
            this.links = links;
            this.resources = new HashSet<ResourceRequest>();
        }

        @Override
        public Builder addLambdaRequest() {
            this.resources.add(new LambdaResourceRequest());
            return this;
        }

        @Override
        public Builder addMplsRequest() {
            this.resources.add(new MplsLabelResourceRequest());
            return this;
        }

        @Override
        public Builder addBandwidthRequest(double bandwidth) {
            this.resources.add(new BandwidthResourceRequest(new BandwidthResource(Bandwidth.bps((double)bandwidth))));
            return this;
        }

        @Override
        public LinkResourceRequest.Builder addConstraint(Constraint constraint) {
            if (constraint instanceof LambdaConstraint) {
                return this.addLambdaRequest();
            }
            if (constraint instanceof BandwidthConstraint) {
                BandwidthConstraint bw = (BandwidthConstraint)constraint;
                return this.addBandwidthRequest(bw.bandwidth().toDouble());
            }
            return this;
        }

        @Override
        public LinkResourceRequest build() {
            return new DefaultLinkResourceRequest(this.intentId, this.links, this.resources);
        }
    }
}

