/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.topology.DefaultTopologyEdge;
import org.onosproject.net.topology.DefaultTopologyVertex;
import org.onosproject.net.topology.GraphDescription;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphDescription
extends AbstractDescription
implements GraphDescription {
    private static final Logger log = LoggerFactory.getLogger(DefaultGraphDescription.class);
    private final long nanos;
    private final long creationTime;
    private final ImmutableSet<TopologyVertex> vertexes;
    private final ImmutableSet<TopologyEdge> edges;
    private final Map<DeviceId, TopologyVertex> vertexesById = Maps.newHashMap();

    @Deprecated
    public DefaultGraphDescription(long nanos, Iterable<Device> devices, Iterable<Link> links, SparseAnnotations ... annotations) {
        this(nanos, System.currentTimeMillis(), devices, links, annotations);
    }

    public DefaultGraphDescription(long nanos, long millis, Iterable<Device> devices, Iterable<Link> links, SparseAnnotations ... annotations) {
        super(annotations);
        this.nanos = nanos;
        this.creationTime = millis;
        this.vertexes = this.buildVertexes(devices);
        this.edges = this.buildEdges(links);
        this.vertexesById.clear();
    }

    @Override
    public long timestamp() {
        return this.nanos;
    }

    @Override
    public long creationTime() {
        return this.creationTime;
    }

    @Override
    public ImmutableSet<TopologyVertex> vertexes() {
        return this.vertexes;
    }

    @Override
    public ImmutableSet<TopologyEdge> edges() {
        return this.edges;
    }

    private ImmutableSet<TopologyVertex> buildVertexes(Iterable<Device> devices) {
        ImmutableSet.Builder vertexes = ImmutableSet.builder();
        for (Device device : devices) {
            DefaultTopologyVertex vertex = new DefaultTopologyVertex(device.id());
            vertexes.add((Object)vertex);
            this.vertexesById.put(vertex.deviceId(), vertex);
        }
        return vertexes.build();
    }

    private ImmutableSet<TopologyEdge> buildEdges(Iterable<Link> links) {
        ImmutableSet.Builder edges = ImmutableSet.builder();
        for (Link link : links) {
            try {
                edges.add((Object)new DefaultTopologyEdge(this.vertexOf(link.src()), this.vertexOf(link.dst()), link));
            }
            catch (IllegalArgumentException e) {
                log.debug("Ignoring {}, missing vertex", (Object)link);
            }
        }
        return edges.build();
    }

    private TopologyVertex vertexOf(ConnectPoint connectPoint) {
        DeviceId id = connectPoint.deviceId();
        TopologyVertex vertex = this.vertexesById.get(id);
        if (vertex == null) {
            throw new IllegalArgumentException("Vertex missing for " + id);
        }
        return vertex;
    }
}

