/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.List;
import org.onosproject.ui.UiMessageHandlerFactory;
import org.onosproject.ui.UiView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiExtension {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String VIEW_PREFIX = "app/view/";
    private final String prefix;
    private final ClassLoader classLoader;
    private final List<UiView> views;
    private final UiMessageHandlerFactory messageHandlerFactory;

    public UiExtension(List<UiView> views, UiMessageHandlerFactory messageHandlerFactory, ClassLoader classLoader) {
        this(views, messageHandlerFactory, null, classLoader);
    }

    public UiExtension(List<UiView> views, UiMessageHandlerFactory messageHandlerFactory, String path, ClassLoader classLoader) {
        this.views = (List)Preconditions.checkNotNull((Object)ImmutableList.copyOf(views), (Object)"Views cannot be null");
        this.messageHandlerFactory = messageHandlerFactory;
        this.prefix = path != null ? path + "/" : "";
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"Class loader must be specified");
    }

    public InputStream css() {
        return this.getStream(this.prefix + "css.html");
    }

    public InputStream js() {
        return this.getStream(this.prefix + "js.html");
    }

    public List<UiView> views() {
        return this.views;
    }

    public InputStream resource(String viewId, String path) {
        return this.getStream(VIEW_PREFIX + viewId + "/" + path);
    }

    public UiMessageHandlerFactory messageHandlerFactory() {
        return this.messageHandlerFactory;
    }

    private InputStream getStream(String path) {
        InputStream stream = this.classLoader.getResourceAsStream(path);
        if (stream == null) {
            this.log.warn("Unable to find resource {}", (Object)path);
        }
        return stream;
    }
}

