/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.table;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onosproject.ui.table.TableModel;

public final class TableUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private TableUtils() {
    }

    public static ArrayNode generateArrayNode(TableModel tm) {
        ArrayNode array = MAPPER.createArrayNode();
        for (TableModel.Row r : tm.getRows()) {
            array.add(TableUtils.toJsonNode(r, tm));
        }
        return array;
    }

    private static JsonNode toJsonNode(TableModel.Row row, TableModel tm) {
        ObjectNode result = MAPPER.createObjectNode();
        String[] keys = tm.getColumnIds();
        String[] cells = row.getAsFormattedStrings();
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            result.put(keys[i], cells[i]);
        }
        return result;
    }
}

