/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Element;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;

public class OchPort
extends DefaultPort {
    private final OduSignalType signalType;
    private final boolean isTunable;
    private final OchSignal lambda;

    public OchPort(Element element, PortNumber number, boolean isEnabled, OduSignalType signalType, boolean isTunable, OchSignal lambda, Annotations ... annotations) {
        super(element, number, isEnabled, Port.Type.OCH, 0L, annotations);
        this.signalType = signalType;
        this.isTunable = isTunable;
        this.lambda = (OchSignal)Preconditions.checkNotNull((Object)lambda);
    }

    public OduSignalType signalType() {
        return this.signalType;
    }

    public boolean isTunable() {
        return this.isTunable;
    }

    public OchSignal lambda() {
        return this.lambda;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.number(), this.isEnabled(), this.type(), this.signalType, this.isTunable, this.lambda, this.annotations()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OchPort) {
            OchPort other = (OchPort)obj;
            return Objects.equals(this.element().id(), other.element().id()) && Objects.equals(this.number(), other.number()) && Objects.equals(this.isEnabled(), other.isEnabled()) && Objects.equals((Object)this.signalType, (Object)other.signalType) && Objects.equals(this.isTunable, other.isTunable) && Objects.equals(this.lambda, other.lambda) && Objects.equals(this.annotations(), other.annotations());
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("element", (Object)this.element().id()).add("number", (Object)this.number()).add("isEnabled", this.isEnabled()).add("type", (Object)this.type()).add("signalType", (Object)this.signalType).add("isTunable", this.isTunable).add("lambda", (Object)this.lambda).toString();
    }
}

