/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.DeviceId;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.BridgeDescription;
import org.onosproject.net.behaviour.BridgeName;

public final class DefaultBridgeDescription
extends AbstractDescription
implements BridgeDescription {
    private final BridgeName name;
    private final DeviceId deviceId;
    private final DeviceId controllerId;

    public DefaultBridgeDescription(BridgeName name, DeviceId controllerId, DeviceId deviceId, SparseAnnotations ... annotations) {
        super(annotations);
        this.name = name;
        this.deviceId = deviceId;
        this.controllerId = controllerId;
    }

    @Override
    public BridgeName bridgeName() {
        return this.name;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public DeviceId cotrollerDeviceId() {
        return this.controllerId;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.deviceId, this.controllerId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultBridgeDescription) {
            DefaultBridgeDescription that = (DefaultBridgeDescription)obj;
            return this.getClass() == that.getClass() && Objects.equals(this.name, that.name) && Objects.equals(this.deviceId, that.deviceId) && Objects.equals(this.controllerId, that.controllerId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("deviceId", (Object)this.deviceId).add("controllerId", (Object)this.controllerId).toString();
    }
}

