/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.onosproject.net.config.ConfigApplyDelegate;

@Beta
public abstract class Config<S> {
    protected S subject;
    protected String key;
    protected JsonNode node;
    protected ObjectNode object;
    protected ArrayNode array;
    protected ObjectMapper mapper;
    protected ConfigApplyDelegate delegate;

    public void init(S subject, String key, JsonNode node, ObjectMapper mapper, ConfigApplyDelegate delegate) {
        this.subject = Preconditions.checkNotNull(subject);
        this.key = key;
        this.node = (JsonNode)Preconditions.checkNotNull((Object)node);
        this.object = node instanceof ObjectNode ? (ObjectNode)node : null;
        this.array = node instanceof ArrayNode ? (ArrayNode)node : null;
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper);
        this.delegate = (ConfigApplyDelegate)Preconditions.checkNotNull((Object)delegate);
    }

    public S subject() {
        return this.subject;
    }

    public String key() {
        return this.key;
    }

    public JsonNode node() {
        return this.node;
    }

    public void apply() {
        this.delegate.onApply(this);
    }

    protected String get(String name, String defaultValue) {
        return this.object.path(name).asText(defaultValue);
    }

    protected Config<S> setOrClear(String name, String value) {
        if (value != null) {
            this.object.put(name, value);
        } else {
            this.object.remove(name);
        }
        return this;
    }

    protected boolean get(String name, boolean defaultValue) {
        return this.object.path(name).asBoolean(defaultValue);
    }

    protected Config<S> setOrClear(String name, Boolean value) {
        if (value != null) {
            this.object.put(name, value.booleanValue());
        } else {
            this.object.remove(name);
        }
        return this;
    }

    protected int get(String name, int defaultValue) {
        return this.object.path(name).asInt(defaultValue);
    }

    protected Config<S> setOrClear(String name, Integer value) {
        if (value != null) {
            this.object.put(name, value.intValue());
        } else {
            this.object.remove(name);
        }
        return this;
    }

    protected long get(String name, long defaultValue) {
        return this.object.path(name).asLong(defaultValue);
    }

    protected Config<S> setOrClear(String name, Long value) {
        if (value != null) {
            this.object.put(name, value.longValue());
        } else {
            this.object.remove(name);
        }
        return this;
    }

    protected double get(String name, double defaultValue) {
        return this.object.path(name).asDouble(defaultValue);
    }

    protected Config<S> setOrClear(String name, Double value) {
        if (value != null) {
            this.object.put(name, value.doubleValue());
        } else {
            this.object.remove(name);
        }
        return this;
    }

    protected <E extends Enum<E>> E get(String name, E defaultValue, Class<E> enumClass) {
        return Enum.valueOf(enumClass, this.object.path(name).asText(defaultValue.toString()));
    }

    protected <E extends Enum> Config<S> setOrClear(String name, E value) {
        if (value != null) {
            this.object.put(name, value.toString());
        } else {
            this.object.remove(name);
        }
        return this;
    }

    protected <T> List<T> getList(String name, Function<String, T> function) {
        ArrayList list = Lists.newArrayList();
        ArrayNode arrayNode = (ArrayNode)this.object.path(name);
        arrayNode.forEach(i -> list.add(function.apply(i.asText())));
        return list;
    }

    protected <T> Config<S> setOrClear(String name, Collection<T> collection) {
        if (collection == null) {
            this.object.remove(name);
        } else {
            ArrayNode arrayNode = this.mapper.createArrayNode();
            collection.forEach(i -> arrayNode.add(i.toString()));
            this.object.set(name, (JsonNode)arrayNode);
        }
        return this;
    }
}

