/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Duration;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.config.basics.AllowedEntityConfig;

public class BasicLinkConfig
extends AllowedEntityConfig<LinkKey> {
    public static final String TYPE = "type";
    public static final String LATENCY = "latency";
    public static final String BANDWIDTH = "bandwidth";
    public static final String IS_DURABLE = "durable";

    public Link.Type type() {
        return this.get(TYPE, Link.Type.DIRECT, Link.Type.class);
    }

    public BasicLinkConfig type(Link.Type type) {
        return (BasicLinkConfig)this.setOrClear(TYPE, type);
    }

    public Duration latency() {
        return Duration.ofNanos(this.get(LATENCY, -1));
    }

    public BasicLinkConfig latency(Duration latency) {
        Long nanos = latency == null ? null : Long.valueOf(latency.toNanos());
        return (BasicLinkConfig)this.setOrClear(LATENCY, nanos);
    }

    public long bandwidth() {
        return this.get(BANDWIDTH, -1);
    }

    public BasicLinkConfig bandwidth(Long bandwidth) {
        return (BasicLinkConfig)this.setOrClear(BANDWIDTH, bandwidth);
    }

    public Boolean isDurable() {
        JsonNode res = this.object.path(IS_DURABLE);
        if (res.isMissingNode()) {
            return null;
        }
        return res.asBoolean();
    }

    public BasicLinkConfig isDurable(Boolean isDurable) {
        return (BasicLinkConfig)this.setOrClear(IS_DURABLE, isDurable);
    }
}

