/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Port;
import org.onosproject.net.config.Config;

public class OpticalPortConfig
extends Config<ConnectPoint> {
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String PORT = "port";
    public static final String STATIC_PORT = "staticPort";
    public static final String STATIC_LAMBDA = "staticLambda";
    public static final String SPEED = "speed";

    public Port.Type type() {
        JsonNode type = this.object.path(TYPE);
        if (type.isMissingNode()) {
            return null;
        }
        return Port.Type.valueOf(type.asText());
    }

    public String name() {
        return this.getStringValue(NAME);
    }

    public String numberName() {
        return this.getStringValue(PORT);
    }

    public String staticPort() {
        return this.getStringValue(STATIC_PORT);
    }

    private String getStringValue(String field) {
        JsonNode name = this.object.path(field);
        return name.isMissingNode() ? "" : name.asText();
    }

    public Optional<Long> staticLambda() {
        JsonNode sl = this.object.path(STATIC_LAMBDA);
        if (sl.isMissingNode()) {
            return Optional.empty();
        }
        return Optional.of(sl.asLong());
    }

    public Optional<Integer> speed() {
        JsonNode s = this.object.path(SPEED);
        if (s.isMissingNode()) {
            return Optional.empty();
        }
        return Optional.of(s.asInt());
    }

    public OpticalPortConfig portType(Port.Type type) {
        String pt = type == null ? null : type.toString();
        return (OpticalPortConfig)this.setOrClear(TYPE, pt);
    }

    public OpticalPortConfig portName(String name) {
        return (OpticalPortConfig)this.setOrClear(NAME, name);
    }

    public OpticalPortConfig portNumberName(Long name) {
        return (OpticalPortConfig)this.setOrClear(PORT, name);
    }

    public OpticalPortConfig staticPort(String name) {
        return (OpticalPortConfig)this.setOrClear(STATIC_PORT, name);
    }

    public OpticalPortConfig staticLambda(Long index) {
        return (OpticalPortConfig)this.setOrClear(STATIC_LAMBDA, index);
    }

    public OpticalPortConfig speed(Integer bw) {
        return (OpticalPortConfig)this.setOrClear(SPEED, bw);
    }
}

