/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.DefaultDriver;
import org.onosproject.net.driver.DefaultDriverProvider;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverResolver;

public class XmlDriverLoader {
    private static final String DRIVERS = "drivers";
    private static final String DRIVER = "driver";
    private static final String BEHAVIOUR = "behaviour";
    private static final String PROPERTY = "property";
    private static final String NAME = "[@name]";
    private static final String EXTENDS = "[@extends]";
    private static final String MFG = "[@manufacturer]";
    private static final String HW = "[@hwVersion]";
    private static final String SW = "[@swVersion]";
    private static final String API = "[@api]";
    private static final String IMPL = "[@impl]";
    private final ClassLoader classLoader;
    private Map<String, Driver> drivers = Maps.newHashMap();

    public XmlDriverLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public DefaultDriverProvider loadDrivers(InputStream driversStream, DriverResolver resolver) throws IOException {
        try {
            XMLConfiguration cfg = new XMLConfiguration();
            cfg.setRootElementName(DRIVERS);
            cfg.setAttributeSplittingDisabled(true);
            cfg.load(driversStream);
            return this.loadDrivers((HierarchicalConfiguration)cfg, resolver);
        }
        catch (ConfigurationException e) {
            throw new IOException("Unable to load drivers", e);
        }
    }

    public DefaultDriverProvider loadDrivers(HierarchicalConfiguration driversCfg, DriverResolver resolver) {
        DefaultDriverProvider provider = new DefaultDriverProvider();
        for (HierarchicalConfiguration cfg : driversCfg.configurationsAt(DRIVER)) {
            DefaultDriver driver = this.loadDriver(cfg, resolver);
            this.drivers.put(driver.name(), driver);
            provider.addDriver(driver);
        }
        this.drivers.clear();
        return provider;
    }

    public DefaultDriver loadDriver(HierarchicalConfiguration driverCfg, DriverResolver resolver) {
        String name = driverCfg.getString(NAME);
        String parentName = driverCfg.getString(EXTENDS);
        String manufacturer = driverCfg.getString(MFG, "");
        String hwVersion = driverCfg.getString(HW, "");
        String swVersion = driverCfg.getString(SW, "");
        Driver parent = parentName != null ? this.resolve(parentName, resolver) : null;
        return new DefaultDriver(name, parent, manufacturer, hwVersion, swVersion, this.parseBehaviours(driverCfg), this.parseProperties(driverCfg));
    }

    private Driver resolve(String parentName, DriverResolver resolver) {
        Driver driver = this.drivers.get(parentName);
        return driver != null ? driver : (resolver != null ? resolver.getDriver(parentName) : null);
    }

    private Map<Class<? extends Behaviour>, Class<? extends Behaviour>> parseBehaviours(HierarchicalConfiguration driverCfg) {
        ImmutableMap.Builder behaviours = ImmutableMap.builder();
        for (HierarchicalConfiguration b : driverCfg.configurationsAt(BEHAVIOUR)) {
            behaviours.put(this.getClass(b.getString(API)), this.getClass(b.getString(IMPL)));
        }
        return behaviours.build();
    }

    private Map<String, String> parseProperties(HierarchicalConfiguration driverCfg) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        for (HierarchicalConfiguration b : driverCfg.configurationsAt(PROPERTY)) {
            properties.put((Object)b.getString(NAME), (Object)((String)b.getRootNode().getValue()));
        }
        return properties.build();
    }

    private Class<? extends Behaviour> getClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to load class " + className, e);
        }
    }
}

