/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRuleExtPayLoad;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;

public interface FlowRule {
    public static final int MAX_TIMEOUT = 60;
    public static final int MIN_PRIORITY = 0;

    public FlowId id();

    public short appId();

    public GroupId groupId();

    public int priority();

    public DeviceId deviceId();

    public TrafficSelector selector();

    public TrafficTreatment treatment();

    public int timeout();

    public boolean isPermanent();

    public int tableId();

    public boolean equals(Object var1);

    public boolean exactMatch(FlowRule var1);

    public FlowRuleExtPayLoad payLoad();

    public static interface Builder {
        public Builder withCookie(long var1);

        public Builder fromApp(ApplicationId var1);

        public Builder withPriority(int var1);

        public Builder forDevice(DeviceId var1);

        public Builder forTable(int var1);

        public Builder withSelector(TrafficSelector var1);

        public Builder withTreatment(TrafficTreatment var1);

        public Builder makePermanent();

        public Builder makeTemporary(int var1);

        public FlowRule build();
    }

    @Deprecated
    public static enum Type {
        DEFAULT,
        IP,
        MPLS,
        ACL,
        VLAN_MPLS,
        VLAN,
        ETHER,
        COS,
        FIRST;

    }
}

