/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class Icmpv6TypeCriterion
implements Criterion {
    private static final short MASK = 255;
    private final short icmpv6Type;

    Icmpv6TypeCriterion(short icmpv6Type) {
        this.icmpv6Type = (short)(icmpv6Type & 0xFF);
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.ICMPV6_TYPE;
    }

    public short icmpv6Type() {
        return this.icmpv6Type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add("icmpv6Type", (int)this.icmpv6Type).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.icmpv6Type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Icmpv6TypeCriterion) {
            Icmpv6TypeCriterion that = (Icmpv6TypeCriterion)obj;
            return Objects.equals(this.icmpv6Type, that.icmpv6Type) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

