/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class VlanPcpCriterion
implements Criterion {
    private static final byte MASK = 7;
    private final byte vlanPcp;

    VlanPcpCriterion(byte vlanPcp) {
        this.vlanPcp = (byte)(vlanPcp & 7);
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.VLAN_PCP;
    }

    public byte priority() {
        return this.vlanPcp;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add("priority", (Object)Long.toHexString(this.vlanPcp)).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.vlanPcp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VlanPcpCriterion) {
            VlanPcpCriterion that = (VlanPcpCriterion)obj;
            return Objects.equals(this.vlanPcp, that.vlanPcp) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

