/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.OchSignal;
import org.onosproject.net.flow.instructions.Instruction;

public abstract class L0ModificationInstruction
implements Instruction {
    public abstract L0SubType subtype();

    @Override
    public final Instruction.Type type() {
        return Instruction.Type.L0MODIFICATION;
    }

    public static final class ModOchSignalInstruction
    extends L0ModificationInstruction {
        private final OchSignal lambda;

        ModOchSignalInstruction(OchSignal lambda) {
            this.lambda = lambda;
        }

        @Override
        public L0SubType subtype() {
            return L0SubType.OCH;
        }

        public OchSignal lambda() {
            return this.lambda;
        }

        public int hashCode() {
            return Objects.hash(this.lambda);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ModOchSignalInstruction)) {
                return false;
            }
            ModOchSignalInstruction that = (ModOchSignalInstruction)obj;
            return Objects.equals(this.lambda, that.lambda);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lambda", (Object)this.lambda).toString();
        }
    }

    public static final class ModLambdaInstruction
    extends L0ModificationInstruction {
        private final L0SubType subtype;
        private final short lambda;

        ModLambdaInstruction(L0SubType subType, short lambda) {
            this.subtype = subType;
            this.lambda = lambda;
        }

        @Override
        public L0SubType subtype() {
            return this.subtype;
        }

        public short lambda() {
            return this.lambda;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("lambda", (int)this.lambda).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype, this.lambda});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModLambdaInstruction) {
                ModLambdaInstruction that = (ModLambdaInstruction)obj;
                return Objects.equals(this.lambda, that.lambda) && Objects.equals((Object)this.subtype, (Object)that.subtype);
            }
            return false;
        }
    }

    public static enum L0SubType {
        LAMBDA,
        OCH;

    }
}

