/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.EthType;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.net.flow.instructions.Instruction;

public abstract class L2ModificationInstruction
implements Instruction {
    public abstract L2SubType subtype();

    @Override
    public final Instruction.Type type() {
        return Instruction.Type.L2MODIFICATION;
    }

    public static final class ModTunnelIdInstruction
    extends L2ModificationInstruction {
        private final long tunnelId;

        ModTunnelIdInstruction(long tunnelId) {
            this.tunnelId = tunnelId;
        }

        public long tunnelId() {
            return this.tunnelId;
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.TUNNEL_ID;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("id", (Object)Long.toHexString(this.tunnelId)).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.tunnelId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModTunnelIdInstruction) {
                ModTunnelIdInstruction that = (ModTunnelIdInstruction)obj;
                return Objects.equals(this.tunnelId, that.tunnelId);
            }
            return false;
        }
    }

    public static final class ModMplsTtlInstruction
    extends L2ModificationInstruction {
        ModMplsTtlInstruction() {
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.DEC_MPLS_TTL;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype()});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof ModMplsTtlInstruction;
        }
    }

    public static final class ModMplsBosInstruction
    extends L2ModificationInstruction {
        private final boolean mplsBos;

        ModMplsBosInstruction(boolean mplsBos) {
            this.mplsBos = mplsBos;
        }

        public boolean mplsBos() {
            return this.mplsBos;
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.MPLS_BOS;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("bos", this.mplsBos).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.mplsBos});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModMplsBosInstruction) {
                ModMplsBosInstruction that = (ModMplsBosInstruction)obj;
                return Objects.equals(this.mplsBos, that.mplsBos());
            }
            return false;
        }
    }

    public static final class ModMplsLabelInstruction
    extends L2ModificationInstruction {
        private final MplsLabel mplsLabel;

        ModMplsLabelInstruction(MplsLabel mplsLabel) {
            this.mplsLabel = mplsLabel;
        }

        @Deprecated
        public Integer label() {
            return this.mplsLabel.toInt();
        }

        public MplsLabel mplsLabel() {
            return this.mplsLabel;
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.MPLS_LABEL;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("mpls", (Object)this.mplsLabel).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.mplsLabel});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModMplsLabelInstruction) {
                ModMplsLabelInstruction that = (ModMplsLabelInstruction)obj;
                return Objects.equals(this.mplsLabel, that.mplsLabel);
            }
            return false;
        }
    }

    public static final class PopVlanInstruction
    extends L2ModificationInstruction {
        private final L2SubType subtype;

        PopVlanInstruction(L2SubType subType) {
            this.subtype = subType;
        }

        @Override
        public L2SubType subtype() {
            return this.subtype;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PopVlanInstruction) {
                PopVlanInstruction that = (PopVlanInstruction)obj;
                return Objects.equals((Object)this.subtype, (Object)that.subtype);
            }
            return false;
        }
    }

    public static final class ModVlanPcpInstruction
    extends L2ModificationInstruction {
        private static final byte MASK = 7;
        private final byte vlanPcp;

        ModVlanPcpInstruction(byte vlanPcp) {
            this.vlanPcp = (byte)(vlanPcp & 7);
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.VLAN_PCP;
        }

        public byte vlanPcp() {
            return this.vlanPcp;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("pcp", (Object)Long.toHexString(this.vlanPcp)).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.vlanPcp});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModVlanPcpInstruction) {
                ModVlanPcpInstruction that = (ModVlanPcpInstruction)obj;
                return Objects.equals(this.vlanPcp, that.vlanPcp);
            }
            return false;
        }
    }

    public static final class ModVlanIdInstruction
    extends L2ModificationInstruction {
        private final VlanId vlanId;

        ModVlanIdInstruction(VlanId vlanId) {
            this.vlanId = vlanId;
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.VLAN_ID;
        }

        public VlanId vlanId() {
            return this.vlanId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("id", (Object)this.vlanId).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.vlanId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModVlanIdInstruction) {
                ModVlanIdInstruction that = (ModVlanIdInstruction)obj;
                return Objects.equals(this.vlanId, that.vlanId);
            }
            return false;
        }
    }

    public static final class PushHeaderInstructions
    extends L2ModificationInstruction {
        private final L2SubType subtype;
        private final EthType ethernetType;

        PushHeaderInstructions(L2SubType subType, EthType ethernetType) {
            this.subtype = subType;
            this.ethernetType = ethernetType;
        }

        public EthType ethernetType() {
            return this.ethernetType;
        }

        @Override
        public L2SubType subtype() {
            return this.subtype;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("ethernetType", (Object)this.ethernetType()).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype, this.ethernetType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PushHeaderInstructions) {
                PushHeaderInstructions that = (PushHeaderInstructions)obj;
                return Objects.equals((Object)this.subtype, (Object)that.subtype) && Objects.equals(this.ethernetType, that.ethernetType);
            }
            return false;
        }
    }

    public static final class ModEtherInstruction
    extends L2ModificationInstruction {
        private final L2SubType subtype;
        private final MacAddress mac;

        ModEtherInstruction(L2SubType subType, MacAddress addr) {
            this.subtype = subType;
            this.mac = addr;
        }

        @Override
        public L2SubType subtype() {
            return this.subtype;
        }

        public MacAddress mac() {
            return this.mac;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("mac", (Object)this.mac).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype, this.mac});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModEtherInstruction) {
                ModEtherInstruction that = (ModEtherInstruction)obj;
                return Objects.equals(this.mac, that.mac) && Objects.equals((Object)this.subtype, (Object)that.subtype);
            }
            return false;
        }
    }

    public static enum L2SubType {
        ETH_SRC,
        ETH_DST,
        VLAN_ID,
        VLAN_PCP,
        MPLS_LABEL,
        MPLS_PUSH,
        MPLS_POP,
        DEC_MPLS_TTL,
        VLAN_POP,
        VLAN_PUSH,
        TUNNEL_ID,
        MPLS_BOS;

    }
}

