/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;

@Beta
public final class DefaultNextObjective
implements NextObjective {
    private final List<TrafficTreatment> treatments;
    private final ApplicationId appId;
    private final NextObjective.Type type;
    private final Integer id;
    private final Objective.Operation op;
    private final Optional<ObjectiveContext> context;

    private DefaultNextObjective(Builder builder) {
        this.treatments = builder.treatments;
        this.appId = builder.appId;
        this.type = builder.type;
        this.id = builder.id;
        this.op = builder.op;
        this.context = Optional.ofNullable(builder.context);
    }

    @Override
    public Collection<TrafficTreatment> next() {
        return this.treatments;
    }

    @Override
    public NextObjective.Type type() {
        return this.type;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public ApplicationId appId() {
        return this.appId;
    }

    @Override
    public int timeout() {
        return 0;
    }

    @Override
    public boolean permanent() {
        return false;
    }

    @Override
    public Objective.Operation op() {
        return this.op;
    }

    @Override
    public Optional<ObjectiveContext> context() {
        return this.context;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements NextObjective.Builder {
        private ApplicationId appId;
        private NextObjective.Type type;
        private Integer id;
        private List<TrafficTreatment> treatments;
        private Objective.Operation op;
        private ObjectiveContext context;
        private final ImmutableList.Builder<TrafficTreatment> listBuilder = ImmutableList.builder();

        @Override
        public Builder withId(int nextId) {
            this.id = nextId;
            return this;
        }

        @Override
        public Builder withType(NextObjective.Type type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder addTreatment(TrafficTreatment treatment) {
            this.listBuilder.add((Object)treatment);
            return this;
        }

        @Override
        public Builder makeTemporary(int timeout) {
            return this;
        }

        @Override
        public Builder makePermanent() {
            return this;
        }

        @Override
        public Builder fromApp(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public Builder withPriority(int priority) {
            return this;
        }

        @Override
        public NextObjective add() {
            this.treatments = this.listBuilder.build();
            this.op = Objective.Operation.ADD;
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"The type cannot be null");
            Preconditions.checkArgument((!this.treatments.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one treatment");
            return new DefaultNextObjective(this);
        }

        @Override
        public NextObjective remove() {
            this.treatments = this.listBuilder.build();
            this.op = Objective.Operation.REMOVE;
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"The type cannot be null");
            return new DefaultNextObjective(this);
        }

        @Override
        public NextObjective add(ObjectiveContext context) {
            this.treatments = this.listBuilder.build();
            this.op = Objective.Operation.ADD;
            this.context = context;
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"The type cannot be null");
            Preconditions.checkArgument((!this.treatments.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one treatment");
            return new DefaultNextObjective(this);
        }

        @Override
        public NextObjective remove(ObjectiveContext context) {
            this.treatments = this.listBuilder.build();
            this.op = Objective.Operation.REMOVE;
            this.context = context;
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"The type cannot be null");
            return new DefaultNextObjective(this);
        }
    }
}

