/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.HostId;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

@Beta
public final class HostToHostIntent
extends ConnectivityIntent {
    private final HostId one;
    private final HostId two;

    public static Builder builder() {
        return new Builder();
    }

    private HostToHostIntent(ApplicationId appId, Key key, HostId one, HostId two, TrafficSelector selector, TrafficTreatment treatment, List<Constraint> constraints, int priority) {
        super(appId, key, (Collection<NetworkResource>)ImmutableSet.of((Object)one, (Object)two), selector, treatment, constraints, priority);
        this.one = (HostId)Preconditions.checkNotNull((Object)one);
        this.two = (HostId)Preconditions.checkNotNull((Object)two);
    }

    public HostId one() {
        return this.one;
    }

    public HostId two() {
        return this.two;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("constraints", this.constraints()).add("one", (Object)this.one).add("two", (Object)this.two).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        HostId one;
        HostId two;

        private Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder one(HostId one) {
            this.one = one;
            return this;
        }

        public Builder two(HostId two) {
            this.two = two;
            return this;
        }

        public HostToHostIntent build() {
            return new HostToHostIntent(this.appId, this.key, this.one, this.two, this.selector, this.treatment, this.constraints, this.priority);
        }
    }
}

