/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.Key;

@Beta
public abstract class Intent {
    private final IntentId id;
    private final ApplicationId appId;
    private final Key key;
    private final int priority;
    public static final int DEFAULT_INTENT_PRIORITY = 100;
    public static final int MAX_PRIORITY = 65535;
    public static final int MIN_PRIORITY = 1;
    private final Collection<NetworkResource> resources;
    private static IdGenerator idGenerator;

    protected Intent() {
        this.id = null;
        this.appId = null;
        this.key = null;
        this.resources = null;
        this.priority = 100;
    }

    protected Intent(ApplicationId appId, Key key, Collection<NetworkResource> resources, int priority) {
        Preconditions.checkState((idGenerator != null ? 1 : 0) != 0, (Object)"Id generator is not bound.");
        Preconditions.checkArgument((priority <= 65535 && priority >= 1 ? 1 : 0) != 0);
        this.id = IntentId.valueOf(idGenerator.getNewId());
        this.appId = (ApplicationId)Preconditions.checkNotNull((Object)appId, (Object)"Application ID cannot be null");
        this.key = key != null ? key : Key.of(this.id.fingerprint(), appId);
        this.priority = priority;
        this.resources = (Collection)Preconditions.checkNotNull(resources);
    }

    public IntentId id() {
        return this.id;
    }

    public ApplicationId appId() {
        return this.appId;
    }

    public int priority() {
        return this.priority;
    }

    public Collection<NetworkResource> resources() {
        return this.resources;
    }

    public boolean isInstallable() {
        return false;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Intent other = (Intent)obj;
        return this.id().equals(other.id());
    }

    public static void bindIdGenerator(IdGenerator newIdGenerator) {
        Preconditions.checkState((idGenerator == null ? 1 : 0) != 0, (Object)"Id generator is already bound.");
        idGenerator = (IdGenerator)Preconditions.checkNotNull((Object)newIdGenerator);
    }

    public static void unbindIdGenerator(IdGenerator oldIdGenerator) {
        if (Objects.equals(idGenerator, oldIdGenerator)) {
            idGenerator = null;
        }
    }

    public Key key() {
        return this.key;
    }

    public static abstract class Builder {
        protected ApplicationId appId;
        protected Key key;
        protected int priority = 100;

        public Builder appId(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }
    }
}

