/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.onlab.packet.MplsLabel;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

@Beta
public final class MplsIntent
extends ConnectivityIntent {
    private final ConnectPoint ingressPoint;
    private final Optional<MplsLabel> ingressLabel;
    private final ConnectPoint egressPoint;
    private final Optional<MplsLabel> egressLabel;

    private MplsIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, Optional<MplsLabel> ingressLabel, ConnectPoint egressPoint, Optional<MplsLabel> egressLabel, List<Constraint> constraints, int priority) {
        super(appId, key, Collections.emptyList(), selector, treatment, constraints, priority);
        this.ingressPoint = (ConnectPoint)Preconditions.checkNotNull((Object)ingressPoint);
        this.ingressLabel = (Optional)Preconditions.checkNotNull(ingressLabel);
        this.egressPoint = (ConnectPoint)Preconditions.checkNotNull((Object)egressPoint);
        this.egressLabel = (Optional)Preconditions.checkNotNull(egressLabel);
        Preconditions.checkArgument((!ingressPoint.equals(egressPoint) ? 1 : 0) != 0, (String)"ingress and egress should be different (ingress: %s, egress: %s)", (Object[])new Object[]{ingressPoint, egressPoint});
    }

    public static Builder builder() {
        return new Builder();
    }

    protected MplsIntent() {
        this.ingressPoint = null;
        this.ingressLabel = null;
        this.egressPoint = null;
        this.egressLabel = null;
    }

    public ConnectPoint ingressPoint() {
        return this.ingressPoint;
    }

    public ConnectPoint egressPoint() {
        return this.egressPoint;
    }

    public Optional<MplsLabel> ingressLabel() {
        return this.ingressLabel;
    }

    public Optional<MplsLabel> egressLabel() {
        return this.egressLabel;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("appId", (Object)this.appId()).add("key", (Object)this.key()).add("priority", this.priority()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("ingressPoint", (Object)this.ingressPoint).add("ingressLabel", this.ingressLabel).add("egressPoint", (Object)this.egressPoint).add("egressLabel", this.egressLabel).add("constraints", this.constraints()).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        ConnectPoint ingressPoint;
        ConnectPoint egressPoint;
        Optional<MplsLabel> ingressLabel;
        Optional<MplsLabel> egressLabel;

        private Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder ingressPoint(ConnectPoint ingressPoint) {
            this.ingressPoint = ingressPoint;
            return this;
        }

        public Builder egressPoint(ConnectPoint egressPoint) {
            this.egressPoint = egressPoint;
            return this;
        }

        public Builder ingressLabel(Optional<MplsLabel> ingressLabel) {
            this.ingressLabel = ingressLabel;
            return this;
        }

        public Builder egressLabel(Optional<MplsLabel> egressLabel) {
            this.egressLabel = egressLabel;
            return this;
        }

        public MplsIntent build() {
            return new MplsIntent(this.appId, this.key, this.selector, this.treatment, this.ingressPoint, this.ingressLabel, this.egressPoint, this.egressLabel, this.constraints, this.priority);
        }
    }
}

