/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

@Beta
public final class PointToPointIntent
extends ConnectivityIntent {
    private final ConnectPoint ingressPoint;
    private final ConnectPoint egressPoint;

    public static Builder builder() {
        return new Builder();
    }

    private PointToPointIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, ConnectPoint egressPoint, List<Constraint> constraints, int priority) {
        super(appId, key, Collections.emptyList(), selector, treatment, constraints, priority);
        Preconditions.checkArgument((!ingressPoint.equals(egressPoint) ? 1 : 0) != 0, (String)"ingress and egress should be different (ingress: %s, egress: %s)", (Object[])new Object[]{ingressPoint, egressPoint});
        this.ingressPoint = (ConnectPoint)Preconditions.checkNotNull((Object)ingressPoint);
        this.egressPoint = (ConnectPoint)Preconditions.checkNotNull((Object)egressPoint);
    }

    protected PointToPointIntent() {
        this.ingressPoint = null;
        this.egressPoint = null;
    }

    public ConnectPoint ingressPoint() {
        return this.ingressPoint;
    }

    public ConnectPoint egressPoint() {
        return this.egressPoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("ingress", (Object)this.ingressPoint).add("egress", (Object)this.egressPoint).add("constraints", this.constraints()).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        ConnectPoint ingressPoint;
        ConnectPoint egressPoint;

        private Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder ingressPoint(ConnectPoint ingressPoint) {
            this.ingressPoint = ingressPoint;
            return this;
        }

        public Builder egressPoint(ConnectPoint egressPoint) {
            this.egressPoint = egressPoint;
            return this;
        }

        public PointToPointIntent build() {
            return new PointToPointIntent(this.appId, this.key, this.selector, this.treatment, this.ingressPoint, this.egressPoint, this.constraints, this.priority);
        }
    }
}

