/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.resource.link.LinkResourceService;

@Beta
public class WaypointConstraint
implements Constraint {
    private final List<DeviceId> waypoints;

    public WaypointConstraint(DeviceId ... waypoints) {
        Preconditions.checkNotNull((Object)waypoints, (Object)"waypoints cannot be null");
        Preconditions.checkArgument((waypoints.length > 0 ? 1 : 0) != 0, (Object)"length of waypoints should be more than 0");
        this.waypoints = ImmutableList.copyOf((Object[])waypoints);
    }

    private WaypointConstraint() {
        this.waypoints = Collections.emptyList();
    }

    public List<DeviceId> waypoints() {
        return this.waypoints;
    }

    @Override
    public double cost(Link link, LinkResourceService resourceService) {
        return 1.0;
    }

    @Override
    public boolean validate(Path path, LinkResourceService resourceService) {
        LinkedList<DeviceId> waypoints = new LinkedList<DeviceId>(this.waypoints);
        DeviceId current = waypoints.poll();
        Link firstLink = path.links().get(0);
        if (firstLink.src().elementId().equals(current)) {
            current = waypoints.poll();
        }
        for (Link link : path.links()) {
            if (!link.dst().elementId().equals(current) || (current = waypoints.poll()) != null) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.waypoints);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WaypointConstraint)) {
            return false;
        }
        WaypointConstraint that = (WaypointConstraint)obj;
        return Objects.equals(this.waypoints, that.waypoints);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("waypoints", this.waypoints).toString();
    }
}

