/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.meter;

import com.google.common.base.Preconditions;

public final class MeterId {
    static final long MAX = -65536L;
    private final long id;
    public static final MeterId SLOWPATH = new MeterId(-3L);
    public static final MeterId CONTROLLER = new MeterId(-2L);
    public static final MeterId ALL = new MeterId(-1L);

    private MeterId(long id) {
        Preconditions.checkArgument((id >= -65536L ? 1 : 0) != 0, (Object)"id cannot be larger than 0xFFFF0000");
        this.id = id;
    }

    public long id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeterId meterId = (MeterId)o;
        return this.id == meterId.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return Long.toHexString(this.id);
    }

    public static MeterId meterId(long id) {
        return new MeterId(id);
    }
}

