/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.newresource;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.newresource.ResourceConsumer;
import org.onosproject.net.newresource.ResourcePath;

@Beta
public class ResourceAllocation {
    private final ResourcePath resource;
    private final ResourceConsumer consumer;

    public ResourceAllocation(ResourcePath resource, ResourceConsumer consumer) {
        this.resource = (ResourcePath)Preconditions.checkNotNull((Object)resource);
        this.consumer = consumer;
    }

    private ResourceAllocation() {
        this.resource = null;
        this.consumer = null;
    }

    public ResourcePath resource() {
        return this.resource;
    }

    public ResourceConsumer consumer() {
        return this.consumer;
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.consumer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceAllocation)) {
            return false;
        }
        ResourceAllocation that = (ResourceAllocation)obj;
        return Objects.equals(this.resource, that.resource) && Objects.equals(this.consumer, that.consumer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("resource", (Object)this.resource).add("consumer", (Object)this.consumer).toString();
    }
}

