/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.newresource;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Beta
public final class ResourcePath {
    private final List<Object> resources;
    public static final ResourcePath ROOT = new ResourcePath((List<Object>)ImmutableList.of());

    public static ResourcePath child(ResourcePath parent, Object child) {
        ImmutableList components = ImmutableList.builder().addAll(parent.components()).add(child).build();
        return new ResourcePath((List<Object>)components);
    }

    public ResourcePath(Object ... components) {
        this(Arrays.asList(components));
    }

    public ResourcePath(List<Object> components) {
        Preconditions.checkNotNull(components);
        this.resources = ImmutableList.copyOf(components);
    }

    private ResourcePath() {
        this.resources = null;
    }

    public List<Object> components() {
        return this.resources;
    }

    public Optional<ResourcePath> parent() {
        if (!this.isRoot()) {
            return Optional.of(new ResourcePath(this.resources.subList(0, this.resources.size() - 1)));
        }
        return Optional.empty();
    }

    public boolean isRoot() {
        return this.resources.size() == 0;
    }

    public Object lastComponent() {
        int last = this.resources.size() - 1;
        return this.resources.get(last);
    }

    public int hashCode() {
        return this.resources.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourcePath)) {
            return false;
        }
        ResourcePath that = (ResourcePath)obj;
        return Objects.equals(this.resources, that.resources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("resources", this.resources).toString();
    }
}

