/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.newresource;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.onosproject.net.newresource.ResourceAllocation;
import org.onosproject.net.newresource.ResourceConsumer;
import org.onosproject.net.newresource.ResourcePath;

@Beta
public interface ResourceService {
    default public Optional<ResourceAllocation> allocate(ResourceConsumer consumer, ResourcePath resource) {
        Preconditions.checkNotNull((Object)consumer);
        Preconditions.checkNotNull((Object)resource);
        List<ResourceAllocation> allocations = this.allocate(consumer, (List<ResourcePath>)ImmutableList.of((Object)resource));
        if (allocations.isEmpty()) {
            return Optional.empty();
        }
        if (!1.$assertionsDisabled && allocations.size() != 1) {
            throw new AssertionError();
        }
        ResourceAllocation allocation = allocations.get(0);
        if (!1.$assertionsDisabled && !allocation.resource().equals(resource)) {
            throw new AssertionError();
        }
        return Optional.of(allocation);
    }

    public List<ResourceAllocation> allocate(ResourceConsumer var1, List<ResourcePath> var2);

    default public List<ResourceAllocation> allocate(ResourceConsumer consumer, ResourcePath ... resources) {
        Preconditions.checkNotNull((Object)consumer);
        Preconditions.checkNotNull((Object)resources);
        return this.allocate(consumer, Arrays.asList(resources));
    }

    default public boolean release(ResourceAllocation allocation) {
        Preconditions.checkNotNull((Object)allocation);
        return this.release((List<ResourceAllocation>)ImmutableList.of((Object)allocation));
    }

    public boolean release(List<ResourceAllocation> var1);

    default public boolean release(ResourceAllocation ... allocations) {
        Preconditions.checkNotNull((Object)allocations);
        return this.release((List<ResourceAllocation>)ImmutableList.copyOf((Object[])allocations));
    }

    public boolean release(ResourceConsumer var1);

    public <T> Collection<ResourceAllocation> getResourceAllocations(ResourcePath var1, Class<T> var2);

    public Collection<ResourceAllocation> getResourceAllocations(ResourceConsumer var1);

    public boolean isAvailable(ResourcePath var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

