/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.provider.ProviderRegistry;
import org.onosproject.net.provider.ProviderService;

public abstract class AbstractProviderRegistry<P extends Provider, S extends ProviderService<P>>
implements ProviderRegistry<P, S> {
    private final Map<ProviderId, P> providers = new HashMap<ProviderId, P>();
    private final Map<ProviderId, S> services = new HashMap<ProviderId, S>();
    private final Map<String, P> providersByScheme = new HashMap<String, P>();

    protected abstract S createProviderService(P var1);

    @Override
    public synchronized S register(P provider) {
        Preconditions.checkNotNull(provider, (Object)"Provider cannot be null");
        Preconditions.checkState((!this.services.containsKey(provider.id()) ? 1 : 0) != 0, (String)"Provider %s already registered", (Object[])new Object[]{provider.id()});
        ProviderId pid = provider.id();
        Preconditions.checkState((pid.isAncillary() || !this.providersByScheme.containsKey(pid.scheme()) ? 1 : 0) != 0, (String)"A primary provider with id %s is already registered", (Object[])new Object[]{this.providersByScheme.get(pid.scheme())});
        S service = this.createProviderService(provider);
        this.services.put(provider.id(), service);
        this.providers.put(provider.id(), provider);
        if (!pid.isAncillary()) {
            this.providersByScheme.put(pid.scheme(), provider);
        }
        return service;
    }

    @Override
    public synchronized void unregister(P provider) {
        Preconditions.checkNotNull(provider, (Object)"Provider cannot be null");
        ProviderService service = (ProviderService)this.services.get(provider.id());
        if (service != null && service instanceof AbstractProviderService) {
            ((AbstractProviderService)service).invalidate();
            this.services.remove(provider.id());
            this.providers.remove(provider.id());
            if (!provider.id().isAncillary()) {
                this.providersByScheme.remove(provider.id().scheme());
            }
        }
    }

    @Override
    public synchronized Set<ProviderId> getProviders() {
        return ImmutableSet.copyOf(this.services.keySet());
    }

    protected synchronized P getProvider(ProviderId providerId) {
        return (P)((Provider)this.providers.get(providerId));
    }

    protected synchronized P getProvider(DeviceId deviceId) {
        return (P)((Provider)this.providersByScheme.get(deviceId.uri().getScheme()));
    }
}

