/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.security;

import com.google.common.annotations.Beta;
import java.security.BasicPermission;

@Beta
public class AppPermission
extends BasicPermission {
    protected Type type;

    public AppPermission(String name) {
        super(name.toUpperCase(), "");
        try {
            this.type = Type.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            this.type = null;
        }
    }

    public AppPermission(String name, String actions) {
        super(name.toUpperCase(), actions);
        try {
            this.type = Type.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            this.type = null;
        }
    }

    public AppPermission(Type type) {
        super(type.name(), "");
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        APP_READ,
        APP_EVENT,
        CONFIG_READ,
        CONFIG_WRITE,
        CLUSTER_READ,
        CLUSTER_WRITE,
        CLUSTER_EVENT,
        DEVICE_READ,
        DEVICE_EVENT,
        DRIVER_READ,
        DRIVER_WRITE,
        FLOWRULE_READ,
        FLOWRULE_WRITE,
        FLOWRULE_EVENT,
        GROUP_READ,
        GROUP_WRITE,
        GROUP_EVENT,
        HOST_READ,
        HOST_WRITE,
        HOST_EVENT,
        INTENT_READ,
        INTENT_WRITE,
        INTENT_EVENT,
        LINK_READ,
        LINK_WRITE,
        LINK_EVENT,
        PACKET_READ,
        PACKET_WRITE,
        PACKET_EVENT,
        STATISTIC_READ,
        TOPOLOGY_READ,
        TOPOLOGY_EVENT,
        TUNNEL_READ,
        TUNNEL_WRITE,
        TUNNEL_EVENT,
        STORAGE_WRITE;

    }
}

