/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;

public final class Endpoint {
    private final int port;
    private final IpAddress ip;

    public Endpoint(IpAddress host, int port) {
        this.ip = (IpAddress)Preconditions.checkNotNull((Object)host);
        this.port = port;
    }

    public IpAddress host() {
        return this.ip;
    }

    public int port() {
        return this.port;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ip", (Object)this.ip).add("port", this.port).toString();
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Endpoint that = (Endpoint)obj;
        return Objects.equals(this.port, that.port) && Objects.equals(this.ip, that.ip);
    }
}

