/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

public final class DatabaseUpdate {
    private Type type;
    private String mapName;
    private String key;
    private byte[] value;
    private byte[] currentValue;
    private long currentVersion = -1L;

    public Type type() {
        return this.type;
    }

    public String mapName() {
        return this.mapName;
    }

    public String key() {
        return this.key;
    }

    public byte[] value() {
        return this.value;
    }

    public byte[] currentValue() {
        return this.currentValue;
    }

    public long currentVersion() {
        return this.currentVersion;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("mapName", (Object)this.mapName).add("key", (Object)this.key).add("value", (Object)this.value).add("currentValue", (Object)this.currentValue).add("currentVersion", this.currentVersion).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static /* synthetic */ byte[] access$302(DatabaseUpdate x0, byte[] x1) {
        x0.currentValue = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$402(DatabaseUpdate x0, byte[] x1) {
        x0.value = x1;
        return x1;
    }

    public static final class Builder {
        private DatabaseUpdate update = new DatabaseUpdate();

        public DatabaseUpdate build() {
            this.validateInputs();
            return this.update;
        }

        public Builder withType(Type type) {
            this.update.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null"));
            return this;
        }

        public Builder withMapName(String mapName) {
            this.update.mapName = (String)Preconditions.checkNotNull((Object)mapName, (Object)"mapName cannot be null");
            return this;
        }

        public Builder withKey(String key) {
            this.update.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
            return this;
        }

        public Builder withCurrentValue(byte[] value) {
            DatabaseUpdate.access$302(this.update, (byte[])Preconditions.checkNotNull((Object)value, (Object)"currentValue cannot be null"));
            return this;
        }

        public Builder withValue(byte[] value) {
            DatabaseUpdate.access$402(this.update, (byte[])Preconditions.checkNotNull((Object)value, (Object)"value cannot be null"));
            return this;
        }

        public Builder withCurrentVersion(long version) {
            Preconditions.checkArgument((version >= 0L ? 1 : 0) != 0, (Object)"version cannot be negative");
            this.update.currentVersion = version;
            return this;
        }

        private void validateInputs() {
            Preconditions.checkNotNull((Object)((Object)this.update.type), (Object)"type must be specified");
            Preconditions.checkNotNull((Object)this.update.mapName, (Object)"map name must be specified");
            Preconditions.checkNotNull((Object)this.update.key, (Object)"key must be specified");
            switch (this.update.type) {
                case PUT: 
                case PUT_IF_ABSENT: {
                    Preconditions.checkNotNull((Object)this.update.value, (Object)"value must be specified.");
                    break;
                }
                case PUT_IF_VERSION_MATCH: {
                    Preconditions.checkNotNull((Object)this.update.value, (Object)"value must be specified.");
                    Preconditions.checkState((this.update.currentVersion >= 0L ? 1 : 0) != 0, (Object)"current version must be specified");
                    break;
                }
                case PUT_IF_VALUE_MATCH: {
                    Preconditions.checkNotNull((Object)this.update.value, (Object)"value must be specified.");
                    Preconditions.checkNotNull((Object)this.update.currentValue, (Object)"currentValue must be specified.");
                    break;
                }
                case REMOVE: {
                    break;
                }
                case REMOVE_IF_VERSION_MATCH: {
                    Preconditions.checkState((this.update.currentVersion >= 0L ? 1 : 0) != 0, (Object)"current version must be specified");
                    break;
                }
                case REMOVE_IF_VALUE_MATCH: {
                    Preconditions.checkNotNull((Object)this.update.currentValue, (Object)"currentValue must be specified.");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation type");
                }
            }
        }
    }

    public static enum Type {
        PUT,
        PUT_IF_ABSENT,
        PUT_IF_VERSION_MATCH,
        PUT_IF_VALUE_MATCH,
        REMOVE,
        REMOVE_IF_VERSION_MATCH,
        REMOVE_IF_VALUE_MATCH;

    }
}

