/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.Objects;
import org.onosproject.store.Timestamp;

public class WallClockTimestamp
implements Timestamp {
    private final long unixTimestamp;

    public WallClockTimestamp() {
        this.unixTimestamp = System.currentTimeMillis();
    }

    public WallClockTimestamp(long timestamp) {
        this.unixTimestamp = timestamp;
    }

    @Override
    public int compareTo(Timestamp o) {
        Preconditions.checkArgument((boolean)(o instanceof WallClockTimestamp), (String)"Must be WallClockTimestamp", (Object[])new Object[]{o});
        WallClockTimestamp that = (WallClockTimestamp)o;
        return ComparisonChain.start().compare(this.unixTimestamp, that.unixTimestamp).result();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.unixTimestamp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WallClockTimestamp)) {
            return false;
        }
        WallClockTimestamp that = (WallClockTimestamp)obj;
        return Objects.equals(this.unixTimestamp, that.unixTimestamp);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("unixTimestamp", this.unixTimestamp).toString();
    }

    public long unixTimestamp() {
        return this.unixTimestamp;
    }
}

