/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

public final class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static ObjectNode envelope(String type, long sid, ObjectNode payload) {
        ObjectNode event = MAPPER.createObjectNode();
        event.put("event", type);
        if (sid > 0L) {
            event.put("sid", sid);
        }
        event.set("payload", (JsonNode)payload);
        return event;
    }

    public static ObjectNode envelope(String type, ObjectNode payload) {
        ObjectNode event = MAPPER.createObjectNode();
        event.put("event", type);
        event.set("payload", (JsonNode)payload);
        return event;
    }

    public static String eventType(ObjectNode event) {
        return JsonUtils.string(event, "event", "unknown");
    }

    public static long sid(ObjectNode event) {
        return JsonUtils.number(event, "sid");
    }

    public static ObjectNode payload(ObjectNode event) {
        return (ObjectNode)event.path("payload");
    }

    public static long number(ObjectNode node, String name) {
        return node.path(name).asLong();
    }

    public static String string(ObjectNode node, String name) {
        return node.path(name).asText();
    }

    public static String string(ObjectNode node, String name, String defaultValue) {
        return node.path(name).asText(defaultValue);
    }

    public static ObjectNode node(ObjectNode node, String name) {
        return (ObjectNode)node.path(name);
    }
}

