/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onosproject.ui.table.CellComparator;
import org.onosproject.ui.table.CellFormatter;
import org.onosproject.ui.table.cell.DefaultCellComparator;
import org.onosproject.ui.table.cell.DefaultCellFormatter;

public class TableModel {
    private static final CellComparator DEF_CMP = DefaultCellComparator.INSTANCE;
    private static final CellFormatter DEF_FMT = DefaultCellFormatter.INSTANCE;
    private final String[] columnIds;
    private final Set<String> idSet;
    private final Map<String, CellComparator> comparators = new HashMap<String, CellComparator>();
    private final Map<String, CellFormatter> formatters = new HashMap<String, CellFormatter>();
    private final List<Row> rows = new ArrayList<Row>();
    private static final String DESC = "desc";

    public TableModel(String ... columnIds) {
        Preconditions.checkNotNull((Object)columnIds, (Object)"columnIds cannot be null");
        Preconditions.checkArgument((columnIds.length > 0 ? 1 : 0) != 0, (Object)"must be at least one column");
        this.idSet = Sets.newHashSet((Object[])columnIds);
        if (this.idSet.size() != columnIds.length) {
            throw new IllegalArgumentException("duplicate column ID(s) detected");
        }
        this.columnIds = Arrays.copyOf(columnIds, columnIds.length);
    }

    private void checkId(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"must provide a column ID");
        if (!this.idSet.contains(id)) {
            throw new IllegalArgumentException("unknown column id: " + id);
        }
    }

    public int rowCount() {
        return this.rows.size();
    }

    public int columnCount() {
        return this.columnIds.length;
    }

    public String[] getColumnIds() {
        return this.columnIds;
    }

    public Row[] getRows() {
        return this.rows.toArray(new Row[this.rows.size()]);
    }

    public void setComparator(String columnId, CellComparator comparator) {
        Preconditions.checkNotNull((Object)comparator, (Object)"must provide a comparator");
        this.checkId(columnId);
        this.comparators.put(columnId, comparator);
    }

    private CellComparator getComparator(String columnId) {
        this.checkId(columnId);
        CellComparator cmp = this.comparators.get(columnId);
        return cmp == null ? DEF_CMP : cmp;
    }

    public void setFormatter(String columnId, CellFormatter formatter) {
        Preconditions.checkNotNull((Object)formatter, (Object)"must provide a formatter");
        this.checkId(columnId);
        this.formatters.put(columnId, formatter);
    }

    public CellFormatter getFormatter(String columnId) {
        this.checkId(columnId);
        CellFormatter fmt = this.formatters.get(columnId);
        return fmt == null ? DEF_FMT : fmt;
    }

    public Row addRow() {
        Row r = new Row();
        this.rows.add(r);
        return r;
    }

    public void sort(String columnId, SortDir dir) {
        Collections.sort(this.rows, new RowComparator(columnId, dir));
    }

    public static SortDir sortDir(String s) {
        return !DESC.equals(s) ? SortDir.ASC : SortDir.DESC;
    }

    public class Row {
        private final Map<String, Object> cells = new HashMap<String, Object>();

        public Row cell(String columnId, Object value) {
            TableModel.this.checkId(columnId);
            this.cells.put(columnId, value);
            return this;
        }

        public Object get(String columnId) {
            return this.cells.get(columnId);
        }

        String getAsString(String columnId) {
            return TableModel.this.getFormatter(columnId).format(this.get(columnId));
        }

        public String[] getAsFormattedStrings() {
            ArrayList<String> formatted = new ArrayList<String>(TableModel.this.columnCount());
            for (String c : TableModel.this.columnIds) {
                formatted.add(this.getAsString(c));
            }
            return formatted.toArray(new String[formatted.size()]);
        }
    }

    private class RowComparator
    implements Comparator<Row> {
        private final String columnId;
        private final SortDir dir;
        private final CellComparator cellComparator;

        public RowComparator(String columnId, SortDir dir) {
            this.columnId = columnId;
            this.dir = dir;
            this.cellComparator = TableModel.this.getComparator(columnId);
        }

        @Override
        public int compare(Row a, Row b) {
            Object cellA = a.get(this.columnId);
            Object cellB = b.get(this.columnId);
            int result = this.cellComparator.compare(cellA, cellB);
            return this.dir == SortDir.ASC ? result : -result;
        }
    }

    public static enum SortDir {
        ASC,
        DESC;

    }
}

