/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.InvalidFieldException;

public class ConfigTest {
    private static final String SUBJECT = "subject";
    private static final String KEY = "key";
    private static final String TEXT = "text";
    private static final String LONG = "long";
    private static final String DOUBLE = "double";
    private static final String BOOLEAN = "boolean";
    private static final String MAC = "mac";
    private static final String BAD_MAC = "badMac";
    private static final String IP = "ip";
    private static final String BAD_IP = "badIp";
    private static final String PREFIX = "prefix";
    private static final String BAD_PREFIX = "badPrefix";
    private static final String CONNECT_POINT = "connectPoint";
    private static final String BAD_CONNECT_POINT = "badConnectPoint";
    private static final String TP_PORT = "tpPort";
    private static final String BAD_TP_PORT = "badTpPort";
    private final ObjectMapper mapper = new ObjectMapper();
    private final ConfigApplyDelegate delegate = new TestDelegate();
    private Config<String> cfg;
    private JsonNode json;

    @Before
    public void setUp() {
        this.json = new ObjectMapper().createObjectNode().put(TEXT, "foo").put(LONG, 5).put(DOUBLE, 0.5).put(BOOLEAN, "true").put(MAC, "ab:cd:ef:ca:fe:ed").put(BAD_MAC, "ab:cd:ef:ca:fe.ed").put(IP, "12.34.56.78").put(BAD_IP, "12.34-56.78").put(PREFIX, "12.34.56.78/18").put(BAD_PREFIX, "12.34.56.78-18").put(CONNECT_POINT, "of:0000000000000001/1").put(BAD_CONNECT_POINT, "of:0000000000000001-1").put(TP_PORT, 65535).put(BAD_TP_PORT, 65536);
        this.cfg = new TestConfig();
        this.cfg.init((Object)SUBJECT, KEY, this.json, this.mapper, this.delegate);
    }

    @Test
    public void hasOnlyFields() {
        Assert.assertTrue((String)"has unexpected fields", (boolean)this.cfg.hasOnlyFields(new String[]{TEXT, LONG, DOUBLE, BOOLEAN, MAC, BAD_MAC, IP, BAD_IP, PREFIX, BAD_PREFIX, CONNECT_POINT, BAD_CONNECT_POINT, TP_PORT, BAD_TP_PORT}));
        Assert.assertTrue((String)"did not detect unexpected fields", (boolean)this.expectInvalidField(() -> this.cfg.hasOnlyFields(new String[]{TEXT, LONG, DOUBLE, MAC})));
    }

    @Test
    public void hasFields() {
        Assert.assertTrue((String)"does not have mandatory field", (boolean)this.cfg.hasFields(new String[]{TEXT, LONG, DOUBLE, MAC}));
        Assert.assertTrue((String)"did not detect missing field", (boolean)this.expectInvalidField(() -> this.cfg.hasFields(new String[]{"none"})));
    }

    @Test
    public void isString() {
        Assert.assertTrue((String)"is not proper text", (boolean)this.cfg.isString(TEXT, Config.FieldPresence.MANDATORY, new String[0]));
        Assert.assertTrue((String)"is not proper text", (boolean)this.cfg.isString(TEXT, Config.FieldPresence.MANDATORY, new String[]{"^f.*"}));
        Assert.assertTrue((String)"is not proper text", (boolean)this.cfg.isString(TEXT, Config.FieldPresence.OPTIONAL, new String[]{"^f.*"}));
        Assert.assertTrue((String)"is not proper text", (boolean)this.cfg.isString(TEXT, Config.FieldPresence.OPTIONAL, new String[0]));
        Assert.assertTrue((String)"is not proper text", (boolean)this.cfg.isString("none", Config.FieldPresence.OPTIONAL, new String[0]));
        Assert.assertTrue((String)"did not detect missing field", (boolean)this.expectInvalidField(() -> this.cfg.isString("none", Config.FieldPresence.MANDATORY, new String[0])));
        Assert.assertTrue((String)"did not detect bad text", (boolean)this.expectInvalidField(() -> this.cfg.isString(TEXT, Config.FieldPresence.OPTIONAL, new String[]{"^b.*"})));
    }

    @Test
    public void isNumber() {
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isNumber(LONG, Config.FieldPresence.MANDATORY, new long[0]));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isNumber(LONG, Config.FieldPresence.MANDATORY, new long[]{0L}));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isNumber(LONG, Config.FieldPresence.MANDATORY, new long[]{0L, 10L}));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isNumber(LONG, Config.FieldPresence.MANDATORY, new long[]{5L, 6L}));
        Assert.assertTrue((String)"is not in range", (boolean)this.expectInvalidField(() -> this.cfg.isNumber(LONG, Config.FieldPresence.MANDATORY, new long[]{6L, 10L})));
        Assert.assertTrue((String)"is not in range", (boolean)this.cfg.isNumber(LONG, Config.FieldPresence.MANDATORY, new long[]{4L, 5L}));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isNumber(LONG, Config.FieldPresence.OPTIONAL, new long[]{0L, 10L}));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isNumber(LONG, Config.FieldPresence.OPTIONAL, new long[0]));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isNumber("none", Config.FieldPresence.OPTIONAL, new long[0]));
        Assert.assertTrue((String)"did not detect missing field", (boolean)this.expectInvalidField(() -> this.cfg.isNumber("none", Config.FieldPresence.MANDATORY, new long[0])));
        Assert.assertTrue((String)"is not proper number", (boolean)this.expectInvalidField(() -> this.cfg.isNumber(TEXT, Config.FieldPresence.MANDATORY, new long[0])));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isNumber(DOUBLE, Config.FieldPresence.MANDATORY, new long[]{0L, 1L}));
        Assert.assertTrue((String)"is not in range", (boolean)this.expectInvalidField(() -> this.cfg.isNumber(DOUBLE, Config.FieldPresence.MANDATORY, new long[]{1L, 2L})));
    }

    @Test
    public void isIntegralNumber() {
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isIntegralNumber(LONG, Config.FieldPresence.MANDATORY, new long[0]));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isIntegralNumber(LONG, Config.FieldPresence.MANDATORY, new long[]{0L}));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isIntegralNumber(LONG, Config.FieldPresence.MANDATORY, new long[]{0L, 10L}));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isIntegralNumber(LONG, Config.FieldPresence.MANDATORY, new long[]{5L, 6L}));
        Assert.assertTrue((String)"is not in range", (boolean)this.expectInvalidField(() -> this.cfg.isIntegralNumber(LONG, Config.FieldPresence.MANDATORY, new long[]{6L, 10L})));
        Assert.assertTrue((String)"is not in range", (boolean)this.cfg.isIntegralNumber(LONG, Config.FieldPresence.MANDATORY, new long[]{4L, 5L}));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isIntegralNumber(LONG, Config.FieldPresence.OPTIONAL, new long[]{0L, 10L}));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isIntegralNumber(LONG, Config.FieldPresence.OPTIONAL, new long[0]));
        Assert.assertTrue((String)"is not proper number", (boolean)this.cfg.isIntegralNumber("none", Config.FieldPresence.OPTIONAL, new long[0]));
        Assert.assertTrue((String)"did not detect missing field", (boolean)this.expectInvalidField(() -> this.cfg.isIntegralNumber("none", Config.FieldPresence.MANDATORY, new long[0])));
        Assert.assertTrue((String)"is not proper number", (boolean)this.expectInvalidField(() -> this.cfg.isIntegralNumber(TEXT, Config.FieldPresence.MANDATORY, new long[0])));
        Assert.assertTrue((String)"is not in range", (boolean)this.expectInvalidField(() -> this.cfg.isIntegralNumber(DOUBLE, Config.FieldPresence.MANDATORY, new long[]{0L, 10L})));
    }

    @Test
    public void isDecimal() {
        Assert.assertTrue((String)"is not proper decimal", (boolean)this.cfg.isDecimal(DOUBLE, Config.FieldPresence.MANDATORY, new double[0]));
        Assert.assertTrue((String)"is not proper decimal", (boolean)this.cfg.isDecimal(DOUBLE, Config.FieldPresence.MANDATORY, new double[]{0.0}));
        Assert.assertTrue((String)"is not proper decimal", (boolean)this.cfg.isDecimal(DOUBLE, Config.FieldPresence.MANDATORY, new double[]{0.0, 1.0}));
        Assert.assertTrue((String)"is not proper decimal", (boolean)this.cfg.isDecimal(DOUBLE, Config.FieldPresence.MANDATORY, new double[]{0.5, 0.6}));
        Assert.assertTrue((String)"is not proper decimal", (boolean)this.cfg.isDecimal(DOUBLE, Config.FieldPresence.MANDATORY, new double[]{0.4, 0.5}));
        Assert.assertTrue((String)"is not in range", (boolean)this.expectInvalidField(() -> this.cfg.isDecimal(DOUBLE, Config.FieldPresence.MANDATORY, new double[]{0.6, 1.0})));
        Assert.assertTrue((String)"is not in range", (boolean)this.expectInvalidField(() -> this.cfg.isDecimal(DOUBLE, Config.FieldPresence.MANDATORY, new double[]{0.3, 0.4})));
        Assert.assertTrue((String)"is not proper decimal", (boolean)this.cfg.isDecimal(DOUBLE, Config.FieldPresence.OPTIONAL, new double[]{0.0, 1.0}));
        Assert.assertTrue((String)"is not proper decimal", (boolean)this.cfg.isDecimal(DOUBLE, Config.FieldPresence.OPTIONAL, new double[0]));
        Assert.assertTrue((String)"is not proper decimal", (boolean)this.cfg.isDecimal("none", Config.FieldPresence.OPTIONAL, new double[0]));
        Assert.assertTrue((String)"did not detect missing field", (boolean)this.expectInvalidField(() -> this.cfg.isDecimal("none", Config.FieldPresence.MANDATORY, new double[0])));
    }

    @Test
    public void isBoolean() {
        Assert.assertTrue((String)"is not proper boolean", (boolean)this.cfg.isBoolean(BOOLEAN, Config.FieldPresence.MANDATORY));
        Assert.assertTrue((String)"did not detect missing field", (boolean)this.expectInvalidField(() -> this.cfg.isBoolean("none", Config.FieldPresence.MANDATORY)));
        Assert.assertTrue((String)"is not proper boolean", (boolean)this.cfg.isBoolean("none", Config.FieldPresence.OPTIONAL));
        Assert.assertTrue((String)"did not detect bad boolean", (boolean)this.expectInvalidField(() -> this.cfg.isBoolean(TEXT, Config.FieldPresence.MANDATORY)));
    }

    @Test
    public void isMacAddress() {
        Assert.assertTrue((String)"is not proper mac", (boolean)this.cfg.isMacAddress(MAC, Config.FieldPresence.MANDATORY));
        Assert.assertTrue((String)"is not proper mac", (boolean)this.cfg.isMacAddress(MAC, Config.FieldPresence.OPTIONAL));
        Assert.assertTrue((String)"is not proper mac", (boolean)this.cfg.isMacAddress("none", Config.FieldPresence.OPTIONAL));
        Assert.assertTrue((String)"did not detect missing field", (boolean)this.expectInvalidField(() -> this.cfg.isMacAddress("none", Config.FieldPresence.MANDATORY)));
        Assert.assertTrue((String)"did not detect bad ip", (boolean)this.expectInvalidField(() -> this.cfg.isMacAddress(BAD_MAC, Config.FieldPresence.MANDATORY)));
    }

    @Test
    public void isIpAddress() {
        Assert.assertTrue((String)"is not proper ip", (boolean)this.cfg.isIpAddress(IP, Config.FieldPresence.MANDATORY));
        Assert.assertTrue((String)"is not proper ip", (boolean)this.cfg.isIpAddress(IP, Config.FieldPresence.OPTIONAL));
        Assert.assertTrue((String)"is not proper ip", (boolean)this.cfg.isIpAddress("none", Config.FieldPresence.OPTIONAL));
        Assert.assertTrue((String)"did not detect missing ip", (boolean)this.expectInvalidField(() -> this.cfg.isIpAddress("none", Config.FieldPresence.MANDATORY)));
        Assert.assertTrue((String)"did not detect bad ip", (boolean)this.expectInvalidField(() -> this.cfg.isIpAddress(BAD_IP, Config.FieldPresence.MANDATORY)));
    }

    @Test
    public void isIpPrefix() {
        Assert.assertTrue((String)"is not proper prefix", (boolean)this.cfg.isIpPrefix(PREFIX, Config.FieldPresence.MANDATORY));
        Assert.assertTrue((String)"is not proper prefix", (boolean)this.cfg.isIpPrefix(PREFIX, Config.FieldPresence.OPTIONAL));
        Assert.assertTrue((String)"is not proper prefix", (boolean)this.cfg.isIpPrefix("none", Config.FieldPresence.OPTIONAL));
        Assert.assertTrue((String)"did not detect missing prefix", (boolean)this.expectInvalidField(() -> this.cfg.isIpPrefix("none", Config.FieldPresence.MANDATORY)));
        Assert.assertTrue((String)"did not detect bad prefix", (boolean)this.expectInvalidField(() -> this.cfg.isIpPrefix(BAD_PREFIX, Config.FieldPresence.MANDATORY)));
    }

    @Test
    public void isConnectPoint() {
        Assert.assertTrue((String)"is not proper connectPoint", (boolean)this.cfg.isConnectPoint(CONNECT_POINT, Config.FieldPresence.MANDATORY));
        Assert.assertTrue((String)"is not proper connectPoint", (boolean)this.cfg.isConnectPoint(CONNECT_POINT, Config.FieldPresence.OPTIONAL));
        Assert.assertTrue((String)"is not proper connectPoint", (boolean)this.cfg.isConnectPoint("none", Config.FieldPresence.OPTIONAL));
        Assert.assertTrue((String)"did not detect missing connectPoint", (boolean)this.expectInvalidField(() -> this.cfg.isConnectPoint("none", Config.FieldPresence.MANDATORY)));
        Assert.assertTrue((String)"did not detect bad connectPoint", (boolean)this.expectInvalidField(() -> this.cfg.isConnectPoint(BAD_CONNECT_POINT, Config.FieldPresence.MANDATORY)));
    }

    @Test
    public void isTpPort() {
        Assert.assertTrue((String)"is not proper transport port", (boolean)this.cfg.isTpPort(TP_PORT, Config.FieldPresence.MANDATORY));
        Assert.assertTrue((String)"is not proper transport port", (boolean)this.cfg.isTpPort(TP_PORT, Config.FieldPresence.OPTIONAL));
        Assert.assertTrue((String)"is not proper transport port", (boolean)this.cfg.isTpPort("none", Config.FieldPresence.OPTIONAL));
        Assert.assertTrue((String)"did not detect missing field", (boolean)this.expectInvalidField(() -> this.cfg.isTpPort("none", Config.FieldPresence.MANDATORY)));
        Assert.assertTrue((String)"is not proper transport port", (boolean)this.expectInvalidField(() -> this.cfg.isTpPort(BAD_TP_PORT, Config.FieldPresence.MANDATORY)));
    }

    private boolean expectInvalidField(Runnable runnable) {
        try {
            runnable.run();
            return false;
        }
        catch (InvalidFieldException e) {
            return true;
        }
    }

    private class TestDelegate
    implements ConfigApplyDelegate {
        private TestDelegate() {
        }

        public void onApply(Config config) {
        }
    }

    private class TestConfig
    extends Config<String> {
        private TestConfig() {
        }
    }
}

