/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.config.basics.BasicElementConfig;

public class BasicElementConfigTest {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String E1 = "e1";
    private BasicElementConfig<?> cfg;

    private static void print(String fmt, Object ... args) {
        System.out.println(String.format(fmt, args));
    }

    private static void print(Object o) {
        BasicElementConfigTest.print("%s", o);
    }

    @Before
    public void setUp() {
        this.cfg = new ElmCfg().name(E1);
    }

    @Test
    public void basicNoGeo() {
        BasicElementConfigTest.print(this.cfg);
        Assert.assertFalse((String)"geo set?", (boolean)this.cfg.geoCoordsSet());
        Assert.assertEquals((String)"lat", (double)0.0, (double)this.cfg.latitude(), (double)9.9E-324);
        Assert.assertEquals((String)"lon", (double)0.0, (double)this.cfg.longitude(), (double)9.9E-324);
    }

    @Test
    public void geoLatitudeOnly() {
        this.cfg.latitude(Double.valueOf(0.1));
        BasicElementConfigTest.print(this.cfg);
        Assert.assertTrue((String)"geo NOT set", (boolean)this.cfg.geoCoordsSet());
        Assert.assertEquals((String)"lat", (double)0.1, (double)this.cfg.latitude(), (double)9.9E-324);
        Assert.assertEquals((String)"lon", (double)0.0, (double)this.cfg.longitude(), (double)9.9E-324);
    }

    @Test
    public void geoLongitudeOnly() {
        this.cfg.longitude(Double.valueOf(-0.1));
        BasicElementConfigTest.print(this.cfg);
        Assert.assertTrue((String)"geo NOT set", (boolean)this.cfg.geoCoordsSet());
        Assert.assertEquals((String)"lat", (double)0.0, (double)this.cfg.latitude(), (double)9.9E-324);
        Assert.assertEquals((String)"lon", (double)-0.1, (double)this.cfg.longitude(), (double)9.9E-324);
    }

    @Test
    public void geoLatLong() {
        this.cfg.latitude(Double.valueOf(3.1415)).longitude(Double.valueOf(2.71828));
        BasicElementConfigTest.print(this.cfg);
        Assert.assertTrue((String)"geo NOT set", (boolean)this.cfg.geoCoordsSet());
        Assert.assertEquals((String)"lat", (double)3.1415, (double)this.cfg.latitude(), (double)9.9E-324);
        Assert.assertEquals((String)"lon", (double)2.71828, (double)this.cfg.longitude(), (double)9.9E-324);
    }

    private static class ElmCfg
    extends BasicElementConfig<String> {
        ElmCfg() {
            this.object = MAPPER.createObjectNode();
        }

        public String toString() {
            return this.object.toString();
        }
    }
}

