/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import java.net.URI;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;

public class DefaultDeviceDescriptionTest {
    private static final URI DURI = URI.create("of:foo");
    private static final String MFR = "whitebox";
    private static final String HW = "1.1.x";
    private static final String SW = "3.9.1";
    private static final String SN = "43311-12345";
    private static final ChassisId CID = new ChassisId();
    private static final DefaultAnnotations DA = DefaultAnnotations.builder().set("Key", "Value").build();

    @Test
    public void basics() {
        DefaultDeviceDescription device = new DefaultDeviceDescription(DURI, Device.Type.SWITCH, MFR, HW, SW, SN, CID, new SparseAnnotations[]{DA});
        Assert.assertEquals((String)"incorrect uri", (Object)DURI, (Object)device.deviceUri());
        Assert.assertEquals((String)"incorrect type", (Object)Device.Type.SWITCH, (Object)device.type());
        Assert.assertEquals((String)"incorrect manufacturer", (Object)MFR, (Object)device.manufacturer());
        Assert.assertEquals((String)"incorrect hw", (Object)HW, (Object)device.hwVersion());
        Assert.assertEquals((String)"incorrect sw", (Object)SW, (Object)device.swVersion());
        Assert.assertEquals((String)"incorrect serial", (Object)SN, (Object)device.serialNumber());
        Assert.assertTrue((String)"incorrect toString", (boolean)device.toString().contains("uri=of:foo"));
        Assert.assertTrue((String)"Incorrect chassis", (device.chassisId().value() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"incorrect annotatios", (boolean)device.toString().contains("Key=Value"));
    }
}

