/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.onlab.graph.Edge;
import org.onlab.util.Bandwidth;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.Path;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleExtPayLoad;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.ResourceListener;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.topology.DefaultTopologyEdge;
import org.onosproject.net.topology.DefaultTopologyVertex;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.PathServiceAdapter;
import org.onosproject.net.topology.TopologyVertex;
import org.onosproject.store.Timestamp;

public class IntentTestsMocks {
    private static final MockSelector SELECTOR = new MockSelector();
    private static final MockTreatment TREATMENT = new MockTreatment();

    public static class MockTimestamp
    implements Timestamp {
        final int value;

        public MockTimestamp(int value) {
            this.value = value;
        }

        public int compareTo(Timestamp o) {
            if (!(o instanceof MockTimestamp)) {
                return -1;
            }
            MockTimestamp that = (MockTimestamp)o;
            return this.value - that.value;
        }
    }

    public static class MockIntent
    extends Intent {
        private static AtomicLong counter = new AtomicLong(0L);
        private final Long number;

        public MockIntent(Long number) {
            super(NetTestTools.APP_ID, null, Collections.emptyList(), 100);
            this.number = number;
        }

        public MockIntent(Long number, Collection<NetworkResource> resources) {
            super(NetTestTools.APP_ID, null, resources, 100);
            this.number = number;
        }

        public Long number() {
            return this.number;
        }

        public static Long nextId() {
            return counter.getAndIncrement();
        }

        public String toString() {
            return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("id", (Object)this.id()).add("appId", (Object)this.appId()).toString();
        }
    }

    public static class MockFlowRule
    implements FlowRule {
        static int nextId = 0;
        int priority;
        int tableId;
        long timestamp;
        int id;
        FlowRuleExtPayLoad payLoad;

        public MockFlowRule(int priority) {
            this.priority = priority;
            this.tableId = 0;
            this.timestamp = System.currentTimeMillis();
            this.id = nextId++;
            this.payLoad = null;
        }

        public MockFlowRule(int priority, FlowRuleExtPayLoad payLoad) {
            this.priority = priority;
            this.timestamp = System.currentTimeMillis();
            this.id = nextId++;
            this.payLoad = payLoad;
        }

        public FlowId id() {
            return FlowId.valueOf((long)this.id);
        }

        public short appId() {
            return 0;
        }

        public GroupId groupId() {
            return new DefaultGroupId(0);
        }

        public int priority() {
            return this.priority;
        }

        public DeviceId deviceId() {
            return NetTestTools.did("1");
        }

        public TrafficSelector selector() {
            return SELECTOR;
        }

        public TrafficTreatment treatment() {
            return TREATMENT;
        }

        public int timeout() {
            return 0;
        }

        public int hardTimeout() {
            return 0;
        }

        public FlowRule.FlowRemoveReason reason() {
            return FlowRule.FlowRemoveReason.NO_REASON;
        }

        public boolean isPermanent() {
            return false;
        }

        public int hashCode() {
            return this.priority;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MockFlowRule other = (MockFlowRule)obj;
            return Objects.equals(this.timestamp, other.timestamp) && this.id == other.id;
        }

        public boolean exactMatch(FlowRule rule) {
            return this.equals(rule);
        }

        public int tableId() {
            return this.tableId;
        }

        public FlowRuleExtPayLoad payLoad() {
            return this.payLoad;
        }
    }

    public static final class MockResourceService
    implements ResourceService {
        private final double bandwidth;

        public static ResourceService makeBandwidthResourceService(double bandwidth) {
            return new MockResourceService(bandwidth);
        }

        private MockResourceService(double bandwidth) {
            this.bandwidth = bandwidth;
        }

        public List<ResourceAllocation> allocate(ResourceConsumer consumer, List<? extends Resource> resources) {
            return null;
        }

        public boolean release(List<ResourceAllocation> allocations) {
            return false;
        }

        public boolean release(ResourceConsumer consumer) {
            return false;
        }

        public List<ResourceAllocation> getResourceAllocations(ResourceId id) {
            return null;
        }

        public <T> Collection<ResourceAllocation> getResourceAllocations(DiscreteResourceId parent, Class<T> cls) {
            return null;
        }

        public Collection<ResourceAllocation> getResourceAllocations(ResourceConsumer consumer) {
            return null;
        }

        public Set<Resource> getAvailableResources(DiscreteResourceId parent) {
            return null;
        }

        public <T> Set<Resource> getAvailableResources(DiscreteResourceId parent, Class<T> cls) {
            return null;
        }

        public <T> Set<T> getAvailableResourceValues(DiscreteResourceId parent, Class<T> cls) {
            return null;
        }

        public Set<Resource> getRegisteredResources(DiscreteResourceId parent) {
            return null;
        }

        public boolean isAvailable(Resource resource) {
            if (!resource.isTypeOf(Bandwidth.class)) {
                return false;
            }
            Optional value = resource.valueAs(Double.class);
            return value.filter(requested -> requested <= this.bandwidth).isPresent();
        }

        public void addListener(ResourceListener listener) {
        }

        public void removeListener(ResourceListener listener) {
        }
    }

    public static class MockPathService
    extends PathServiceAdapter {
        final String[] pathHops;
        final String[] reversePathHops;

        public MockPathService(String[] pathHops) {
            this.pathHops = pathHops;
            String[] reversed = (String[])pathHops.clone();
            Collections.reverse(Arrays.asList(reversed));
            this.reversePathHops = reversed;
        }

        @Override
        public Set<Path> getPaths(ElementId src, ElementId dst) {
            HashSet<Path> result = new HashSet<Path>();
            String[] allHops = new String[this.pathHops.length];
            if (src.toString().endsWith(this.pathHops[0])) {
                System.arraycopy(this.pathHops, 0, allHops, 0, this.pathHops.length);
            } else {
                System.arraycopy(this.reversePathHops, 0, allHops, 0, this.pathHops.length);
            }
            result.add(NetTestTools.createPath(src instanceof HostId, dst instanceof HostId, allHops));
            return result;
        }

        @Override
        public Set<Path> getPaths(ElementId src, ElementId dst, LinkWeight weight) {
            Set<Path> paths = this.getPaths(src, dst);
            for (Path path : paths) {
                Link link;
                DefaultTopologyVertex dstVertex;
                DefaultTopologyVertex srcVertex;
                double weightValue;
                DeviceId dstDevice;
                DeviceId srcDevice = path.src().elementId() instanceof DeviceId ? path.src().deviceId() : null;
                DeviceId deviceId = dstDevice = path.dst().elementId() instanceof DeviceId ? path.dst().deviceId() : null;
                if (srcDevice == null || dstDevice == null || !((weightValue = weight.weight((Edge)new DefaultTopologyEdge((TopologyVertex)(srcVertex = new DefaultTopologyVertex(srcDevice)), (TopologyVertex)(dstVertex = new DefaultTopologyVertex(dstDevice)), link = NetTestTools.link(src.toString(), 1, dst.toString(), 1)))) < 0.0)) continue;
                return new HashSet<Path>();
            }
            return paths;
        }
    }

    public static class MockTreatment
    implements TrafficTreatment {
        public List<Instruction> deferred() {
            return Collections.emptyList();
        }

        public List<Instruction> immediate() {
            return Collections.emptyList();
        }

        public List<Instruction> allInstructions() {
            return Collections.emptyList();
        }

        public Instructions.TableTypeTransition tableTransition() {
            return null;
        }

        public boolean clearedDeferred() {
            return false;
        }

        public Instructions.MetadataInstruction writeMetadata() {
            return null;
        }

        public Instructions.MeterInstruction metered() {
            return null;
        }
    }

    public static class MockSelector
    implements TrafficSelector {
        public Set<Criterion> criteria() {
            return new HashSet<Criterion>();
        }

        public Criterion getCriterion(Criterion.Type type) {
            return null;
        }
    }
}

