/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.intent.ConnectivityIntentTest;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;

public class MultiPointToSinglePointIntentTest
extends ConnectivityIntentTest {
    @Rule
    public ExpectedException wrongMultiple = ExpectedException.none();

    @Test
    public void checkImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(MultiPointToSinglePointIntent.class);
    }

    @Test
    public void basics() {
        MultiPointToSinglePointIntent intent = this.createOne();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)PS1, (Object)intent.ingressPoints());
        Assert.assertEquals((String)"incorrect egress", (Object)P2, (Object)intent.egressPoint());
    }

    @Test
    public void multipleSelectors() {
        MultiPointToSinglePointIntent intent = this.createFirstMultiple();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)PS1, (Object)intent.ingressPoints());
        Assert.assertEquals((String)"incorrect egress", (Object)P2, (Object)intent.egressPoint());
        Assert.assertEquals((String)"incorrect selectors", (Object)MATCHES, (Object)intent.ingressSelectors());
        intent = this.createSecondMultiple();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)VLANMATCH1, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)PS1, (Object)intent.ingressPoints());
        Assert.assertEquals((String)"incorrect egress", (Object)P2, (Object)intent.egressPoint());
        Assert.assertEquals((String)"incorrect selectors", (Object)MATCHES, (Object)intent.ingressSelectors());
        intent = this.createThirdMultiple();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)PS1, (Object)intent.ingressPoints());
        Assert.assertEquals((String)"incorrect egress", (Object)P2, (Object)intent.egressPoint());
        Assert.assertEquals((String)"incorrect selectors", (Object)VLANMATCHES, (Object)intent.ingressSelectors());
        this.wrongMultiple.expect(IllegalArgumentException.class);
        this.wrongMultiple.expectMessage("Selector and Multiple Selectors are both set");
        intent = this.createWrongMultiple();
    }

    protected MultiPointToSinglePointIntent createOne() {
        return MultiPointToSinglePointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).ingressPoints(PS1).egressPoint(P2).build();
    }

    protected MultiPointToSinglePointIntent createAnother() {
        return MultiPointToSinglePointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).ingressPoints(PS2).egressPoint(P1).build();
    }

    protected MultiPointToSinglePointIntent createFirstMultiple() {
        return MultiPointToSinglePointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).ingressPoints(PS1).egressPoint(P2).selectors(MATCHES).build();
    }

    protected MultiPointToSinglePointIntent createSecondMultiple() {
        return MultiPointToSinglePointIntent.builder().appId(APPID).selector(VLANMATCH1).treatment(NOP).ingressPoints(PS1).egressPoint(P2).selectors(MATCHES).build();
    }

    protected MultiPointToSinglePointIntent createThirdMultiple() {
        return MultiPointToSinglePointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).ingressPoints(PS1).egressPoint(P2).selectors(VLANMATCHES).build();
    }

    protected MultiPointToSinglePointIntent createWrongMultiple() {
        return MultiPointToSinglePointIntent.builder().appId(APPID).selector(VLANMATCH1).treatment(NOP).ingressPoints(PS1).egressPoint(P2).selectors(VLANMATCHES).build();
    }
}

