/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.intent.ConnectivityIntentTest;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;

public class SinglePointToMultiPointIntentTest
extends ConnectivityIntentTest {
    @Rule
    public ExpectedException wrongMultiple = ExpectedException.none();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(SinglePointToMultiPointIntent.class);
    }

    @Test
    public void basics() {
        SinglePointToMultiPointIntent intent = this.createOne();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)P1, (Object)intent.ingressPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)PS2, (Object)intent.egressPoints());
    }

    @Test
    public void multipleTreatments() {
        SinglePointToMultiPointIntent intent = this.createFirstMultiple();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)P1, (Object)intent.ingressPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)PS2, (Object)intent.egressPoints());
        Assert.assertEquals((String)"incorrect treatment", (Object)NOP, (Object)intent.treatment());
        Assert.assertEquals((String)"incorrect treatments", (Object)TREATMENTS, (Object)intent.egressTreatments());
        intent = this.createSecondMultiple();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)P1, (Object)intent.ingressPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)PS2, (Object)intent.egressPoints());
        Assert.assertEquals((String)"incorrect treatment", (Object)VLANACTION1, (Object)intent.treatment());
        Assert.assertEquals((String)"incorrect selectors", (Object)TREATMENTS, (Object)intent.egressTreatments());
        intent = this.createThirdMultiple();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)P1, (Object)intent.ingressPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)PS2, (Object)intent.egressPoints());
        Assert.assertEquals((String)"incorrect treatment", (Object)NOP, (Object)intent.treatment());
        Assert.assertEquals((String)"incorrect selectors", (Object)VLANACTIONS, (Object)intent.egressTreatments());
        this.wrongMultiple.expect(IllegalArgumentException.class);
        this.wrongMultiple.expectMessage("Treatment and Multiple Treatments are both set");
        intent = this.createWrongMultiple();
    }

    protected SinglePointToMultiPointIntent createOne() {
        return SinglePointToMultiPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).ingressPoint(P1).egressPoints(PS2).build();
    }

    protected SinglePointToMultiPointIntent createAnother() {
        return SinglePointToMultiPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).ingressPoint(P2).egressPoints(PS1).build();
    }

    protected SinglePointToMultiPointIntent createFirstMultiple() {
        return SinglePointToMultiPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).ingressPoint(P1).egressPoints(PS2).treatments(TREATMENTS).build();
    }

    protected SinglePointToMultiPointIntent createSecondMultiple() {
        return SinglePointToMultiPointIntent.builder().appId(APPID).selector(MATCH).treatment(VLANACTION1).ingressPoint(P1).egressPoints(PS2).treatments(TREATMENTS).build();
    }

    protected SinglePointToMultiPointIntent createThirdMultiple() {
        return SinglePointToMultiPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).ingressPoint(P1).egressPoints(PS2).treatments(VLANACTIONS).build();
    }

    protected SinglePointToMultiPointIntent createWrongMultiple() {
        return SinglePointToMultiPointIntent.builder().appId(APPID).selector(MATCH).treatment(VLANACTION1).ingressPoint(P1).egressPoints(PS2).treatments(VLANACTIONS).build();
    }
}

