/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.net.TributarySlot;
import org.onosproject.net.resource.ContinuousResourceId;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.ResourceListener;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;

public class MockResourceService
implements ResourceService {
    private final Map<Resource, ResourceConsumer> assignment = new HashMap<Resource, ResourceConsumer>();

    public List<ResourceAllocation> allocate(ResourceConsumer consumer, List<? extends Resource> resources) {
        this.assignment.putAll(resources.stream().collect(Collectors.toMap(Function.identity(), x -> consumer)));
        return resources.stream().map(x -> new ResourceAllocation(x, consumer)).collect(Collectors.toList());
    }

    public boolean release(List<ResourceAllocation> allocations) {
        allocations.forEach(x -> this.assignment.remove(x.resource()));
        return true;
    }

    public boolean release(ResourceConsumer consumer) {
        List resources = this.assignment.entrySet().stream().filter(x -> ((ResourceConsumer)x.getValue()).equals(consumer)).map(Map.Entry::getKey).collect(Collectors.toList());
        List<ResourceAllocation> allocations = resources.stream().map(x -> new ResourceAllocation(x, consumer)).collect(Collectors.toList());
        return this.release(allocations);
    }

    public List<ResourceAllocation> getResourceAllocations(ResourceId id) {
        if (id instanceof ContinuousResourceId) {
            return ImmutableList.of();
        }
        DiscreteResource discrete = Resources.discrete((DiscreteResourceId)((DiscreteResourceId)id)).resource();
        return (List)Optional.ofNullable(this.assignment.get(discrete)).map(x -> ImmutableList.of((Object)new ResourceAllocation((Resource)discrete, x))).orElse(ImmutableList.of());
    }

    public <T> Collection<ResourceAllocation> getResourceAllocations(DiscreteResourceId parent, Class<T> cls) {
        return this.assignment.entrySet().stream().filter(x -> ((Resource)x.getKey()).parent().isPresent()).filter(x -> ((DiscreteResource)((Resource)x.getKey()).parent().get()).id().equals((Object)parent)).map(x -> new ResourceAllocation((Resource)x.getKey(), (ResourceConsumer)x.getValue())).collect(Collectors.toList());
    }

    public Collection<ResourceAllocation> getResourceAllocations(ResourceConsumer consumer) {
        return this.assignment.entrySet().stream().filter(x -> ((ResourceConsumer)x.getValue()).equals(consumer)).map(x -> new ResourceAllocation((Resource)x.getKey(), (ResourceConsumer)x.getValue())).collect(Collectors.toList());
    }

    private Collection<Resource> addVlanIds(DiscreteResourceId parent) {
        HashSet<Resource> resources = new HashSet<Resource>();
        for (int i = 1; i < 4095; ++i) {
            resources.add((Resource)Resources.discrete((DiscreteResourceId)parent).resource().child((Object)VlanId.vlanId((short)((short)i))));
        }
        return resources;
    }

    public Set<Resource> getAvailableResources(DiscreteResourceId parent) {
        HashSet<Object> resources = new HashSet<Object>();
        resources.addAll(this.addVlanIds(parent));
        resources.add(Resources.discrete((DiscreteResourceId)parent).resource().child((Object)MplsLabel.mplsLabel((int)10)));
        resources.add(Resources.discrete((DiscreteResourceId)parent).resource().child((Object)TributarySlot.of((long)1L)));
        resources.add(Resources.discrete((DiscreteResourceId)parent).resource().child((Object)TributarySlot.of((long)2L)));
        resources.add(Resources.discrete((DiscreteResourceId)parent).resource().child((Object)TributarySlot.of((long)3L)));
        resources.add(Resources.discrete((DiscreteResourceId)parent).resource().child((Object)TributarySlot.of((long)4L)));
        resources.add(Resources.discrete((DiscreteResourceId)parent).resource().child((Object)TributarySlot.of((long)5L)));
        resources.add(Resources.discrete((DiscreteResourceId)parent).resource().child((Object)TributarySlot.of((long)6L)));
        resources.add(Resources.discrete((DiscreteResourceId)parent).resource().child((Object)TributarySlot.of((long)7L)));
        resources.add(Resources.discrete((DiscreteResourceId)parent).resource().child((Object)TributarySlot.of((long)8L)));
        return ImmutableSet.copyOf(resources);
    }

    public <T> Set<Resource> getAvailableResources(DiscreteResourceId parent, Class<T> cls) {
        return this.getAvailableResources(parent).stream().filter(x -> x.isTypeOf(cls)).collect(Collectors.toSet());
    }

    public <T> Set<T> getAvailableResourceValues(DiscreteResourceId parent, Class<T> cls) {
        return this.getAvailableResources(parent).stream().filter(x -> x.isTypeOf(cls)).flatMap(x -> Tools.stream((Optional)x.valueAs(cls))).collect(Collectors.toSet());
    }

    public Set<Resource> getRegisteredResources(DiscreteResourceId parent) {
        return this.getAvailableResources(parent);
    }

    public boolean isAvailable(Resource resource) {
        return true;
    }

    public void addListener(ResourceListener listener) {
    }

    public void removeListener(ResourceListener listener) {
    }
}

