/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.EdgeLink;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.ui.model.AbstractUiModelTest;
import org.onosproject.ui.model.topo.UiEdgeLink;
import org.onosproject.ui.model.topo.UiLinkId;

public class UiEdgeLinkTest
extends AbstractUiModelTest {
    private static final String PHANTOM_HOST_ID = "00:00:00:00:00:00/None";
    private static final String D1_P8 = "dev-1/8";
    private static final DeviceId DEV = DeviceId.deviceId((String)"dev-1");
    private static final PortNumber P8 = PortNumber.portNumber((long)8L);
    private static final ConnectPoint CP = new ConnectPoint((ElementId)DEV, P8);
    private static final EdgeLink EDGE_LINK = DefaultEdgeLink.createEdgeLink((ConnectPoint)CP, (boolean)true);

    @Test
    public void basic() {
        UiEdgeLinkTest.title("basic");
        UiLinkId id = UiLinkId.uiLinkId((Link)EDGE_LINK);
        UiEdgeLink link = new UiEdgeLink(null, id);
        link.attachEdgeLink(EDGE_LINK);
        UiEdgeLinkTest.print(link);
        UiEdgeLinkTest.print(link.endPointA());
        UiEdgeLinkTest.print(link.endPointB());
        Assert.assertEquals((String)"bad end point A", (Object)PHANTOM_HOST_ID, (Object)link.endPointA());
        Assert.assertEquals((String)"bad end point B", (Object)D1_P8, (Object)link.endPointB());
    }
}

